/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel.screen;

import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import org.carpetorgaddition.mixin.accessor.HorseScreenHandlerAccessor;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.wheel.DisabledSlot;
import org.carpetorgaddition.wheel.inventory.AbstractCustomSizeInventory;
import org.carpetorgaddition.wheel.screen.BackgroundSpriteSyncServer;
import org.carpetorgaddition.wheel.screen.UnavailableSlotSyncInterface;

public abstract class AbstractPlayerInventoryScreenHandler<T extends class_1263>
extends class_1703
implements UnavailableSlotSyncInterface,
BackgroundSpriteSyncServer {
    public static final ThreadLocal<Boolean> isQuickMovingItem = ThreadLocal.withInitial(() -> false);
    protected static final Map<Integer, class_2960> BACKGROUND_SPRITE_MAP = Map.of(36, class_1723.field_21669, 37, class_1723.field_21670, 38, class_1723.field_21671, 39, class_1723.field_21672, 40, class_1723.field_21673, 41, HorseScreenHandlerAccessor.getEmptyHorseArmorSlotTexture(), 42, HorseScreenHandlerAccessor.getEmptySaddleSlotTexture());
    protected static final int SIZE = 43;
    protected final T inventory;

    public AbstractPlayerInventoryScreenHandler(int syncId, class_1661 playerInventory, T inventory) {
        super(class_3917.field_17327, syncId);
        this.inventory = inventory;
        this.addOfflinePlayerInventorySlot();
        this.addPlayerInventorySlot(playerInventory);
        this.addHotSlot(playerInventory);
        AbstractCustomSizeInventory.PLACEHOLDER.method_7939(1);
    }

    private void addOfflinePlayerInventorySlot() {
        int index = 0;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (index >= 43) {
                    this.method_7621(new DisabledSlot((class_1263)this.inventory, index, 8 + j * 18, 18 + i * 18));
                } else {
                    this.method_7621(new class_1735(this.inventory, this.getIndex(index), 8 + j * 18, 18 + i * 18));
                }
                ++index;
            }
        }
    }

    private void addPlayerInventorySlot(class_1661 inventory) {
        int index = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)inventory, index + 9, 8 + j * 18, 103 + i * 18 + 36));
                ++index;
            }
        }
    }

    private void addHotSlot(class_1661 inventory) {
        for (int index = 0; index < 9; ++index) {
            this.method_7621(new class_1735((class_1263)inventory, index, 8 + index * 18, 197));
        }
    }

    private int getIndex(int index) {
        if (index < 36) {
            return index;
        }
        if (index < 40) {
            return 36 + (39 - index);
        }
        return index;
    }

    public class_1799 method_7601(class_1657 player, int slotIndex) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(slotIndex);
        if (slot.method_7681()) {
            class_1799 slotItemStack = slot.method_7677();
            itemStack = slotItemStack.method_7972();
            if (slotIndex < 54 ? this.quickMove(slotItemStack, 54, this.field_7761.size(), true) : this.quickMove(slotItemStack, 0, 41, false)) {
                return class_1799.field_8037;
            }
            if (slotItemStack.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return itemStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean quickMove(class_1799 stack, int startIndex, int endIndex, boolean fromLast) {
        try {
            isQuickMovingItem.set(true);
            boolean bl = !this.method_7616(stack, startIndex, endIndex, fromLast);
            return bl;
        }
        finally {
            isQuickMovingItem.set(false);
        }
    }

    @Override
    public int from() {
        return 43;
    }

    @Override
    public int to() {
        return 53;
    }

    @Override
    public Map<Integer, class_2960> getBackgroundSprite() {
        return BACKGROUND_SPRITE_MAP;
    }

    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        if (MathUtils.isInRange(this.from(), this.to(), slotIndex)) {
            return;
        }
        super.method_7593(slotIndex, button, actionType, player);
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        AbstractCustomSizeInventory.PLACEHOLDER.method_7939(1);
    }
}

