/*
 * Decompiled with CFR 0.152.
 */
package net.rain.dream_stone.event;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.rain.dream_stone.DreamStone;
import net.rain.dream_stone.component.AutoRepairData;

@EventBusSubscriber(modid="dream_stone", bus=EventBusSubscriber.Bus.GAME)
public class PlayerTickHandler {
    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        AutoRepairData repairData;
        Player player = event.getEntity();
        if (player.level().isClientSide()) {
            return;
        }
        ItemStack mainHandItem = player.getMainHandItem();
        if (!mainHandItem.isEmpty() && mainHandItem.isDamageableItem() && mainHandItem.isDamaged() && (repairData = (AutoRepairData)mainHandItem.get(DreamStone.AUTO_REPAIR)) != null && repairData.enabled() && player.tickCount % repairData.repairInterval() == 0) {
            PlayerTickHandler.repairItem(mainHandItem, repairData.repairAmount());
        }
    }

    private static void repairItem(ItemStack stack, int repairAmount) {
        int currentDamage = stack.getDamageValue();
        if (currentDamage > 0) {
            int newDamage = Math.max(0, currentDamage - repairAmount);
            stack.setDamageValue(newDamage);
        }
    }
}

