/*
 * Decompiled with CFR 0.152.
 */
package net.rain.dream_stone;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="dream_stone", bus=EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.ConfigValue<List<? extends String>> BANNED_ITEMS = BUILDER.comment("A list of items that cannot be made unbreakable with Dream Stone.").defineListAllowEmpty("bannedItems", List.of("minecraft:barrier", "minecraft:bedrock"), Config::validateItemName);
    private static final ModConfigSpec.ConfigValue<String> TOOLTIP_TEXT = BUILDER.comment("The text to display in the rainbow tooltip for items with RealUnbreak component.").define("tooltipText", (Object)"\u68a6\u4e4b\u77f3");
    static final ModConfigSpec SPEC = BUILDER.build();
    public static Set<Item> bannedItems;
    public static String tooltipText;

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && BuiltInRegistries.ITEM.containsKey(ResourceLocation.parse((String)(itemName = (String)obj)));
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        bannedItems = ((List)BANNED_ITEMS.get()).stream().map(itemName -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet());
        tooltipText = (String)TOOLTIP_TEXT.get();
    }
}

