/*
 * Decompiled with CFR 0.152.
 */
package net.rain.dream_stone.mixin;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.rain.dream_stone.DreamStone;
import net.rain.dream_stone.component.RealUnbreakData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemEntity.class}, priority=1000000)
public abstract class ItemEntityMixin
extends Entity {
    @Shadow(remap=false)
    public int lifespan;
    @Shadow
    private int health;

    public ItemEntityMixin(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Shadow
    public abstract ItemStack getItem();

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;DDD)V"}, at={@At(value="RETURN")})
    private void onInit(Level pLevel, double pPosX, double pPosY, double pPosZ, ItemStack pItemStack, double pDeltaX, double pDeltaY, double pDeltaZ, CallbackInfo ci) {
        RealUnbreakData realUnbreakData = (RealUnbreakData)pItemStack.get((DataComponentType)DreamStone.REAL_UNBREAK.get());
        if (realUnbreakData != null && realUnbreakData.enabled()) {
            this.lifespan = Integer.MAX_VALUE;
            this.health = Integer.MAX_VALUE;
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHurt(DamageSource pSource, float pAmount, CallbackInfoReturnable<Boolean> cir) {
        ItemStack itemStack = this.getItem();
        RealUnbreakData realUnbreakData = (RealUnbreakData)itemStack.get((DataComponentType)DreamStone.REAL_UNBREAK.get());
        if (realUnbreakData != null && realUnbreakData.enabled()) {
            cir.setReturnValue((Object)false);
        }
    }
}

