/*
 * Decompiled with CFR 0.152.
 */
package com.dreamstone.config;

import com.dreamstone.DreamStone;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("dream-stone.json");
    private static ConfigData configData = new ConfigData();
    private static boolean itemsProcessed = false;
    private static Set<class_1792> bannedItemsCache = new HashSet<class_1792>();
    public static String tooltipText = "\u68a6\u4e4b\u77f3";

    public static Set<class_1792> getBannedItems() {
        if (!itemsProcessed) {
            Config.processConfig();
            itemsProcessed = true;
        }
        return bannedItemsCache;
    }

    public static void load() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                String json = Files.readString(CONFIG_PATH);
                configData = (ConfigData)GSON.fromJson(json, ConfigData.class);
            } else {
                Config.save();
            }
            tooltipText = Config.configData.tooltipText;
        }
        catch (IOException e) {
            DreamStone.LOGGER.error("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    private static void save() {
        try {
            String json = GSON.toJson((Object)configData);
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            DreamStone.LOGGER.error("\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    private static void processConfig() {
        try {
            bannedItemsCache = Config.configData.bannedItems.stream().map(class_2960::new).map(arg_0 -> ((class_7922)class_7923.field_41178).method_10223(arg_0)).filter(item -> item != class_1802.field_8162).collect(Collectors.toSet());
        }
        catch (Exception e) {
            DreamStone.LOGGER.error("\u89e3\u6790\u7981\u6b62\u7269\u54c1\u5217\u8868\u5931\u8d25", (Throwable)e);
            bannedItemsCache = new HashSet<class_1792>();
        }
    }

    public static class ConfigData {
        public List<String> bannedItems = new ArrayList<String>();
        public String tooltipText = "\u68a6\u4e4b\u77f3";

        public ConfigData() {
            this.bannedItems.add("minecraft:barrier");
            this.bannedItems.add("minecraft:bedrock");
        }
    }
}

