/*
 * Decompiled with CFR 0.152.
 */
package com.bmt.dream_stone;

import com.bmt.dream_stone.Config;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dream_stone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ItemRinbowTooltipEvent {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41783_() != null && stack.m_41783_().m_128471_("RealUnbreak")) {
            String displayText = Config.tooltipText != null ? Config.tooltipText : "\u68a6\u4e4b\u77f3";
            ItemRinbowTooltipEvent.addRainbowTooltip(event.getToolTip(), displayText, 3);
        }
    }

    private static void addRainbowTooltip(List<Component> tooltip, String text, int index) {
        long time = System.currentTimeMillis();
        MutableComponent coloredText = Component.m_237119_();
        double globalSpeed = 5.0;
        double characterSpacing = 0.25;
        double preciseTime = time / 250L;
        double bluePhase = 0.0;
        double purplePhase = 2.0943951023931953;
        double pinkPhase = 4.1887902047863905;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            double characterOffset = (double)i / (double)text.length() * characterSpacing;
            double timeOffset = preciseTime + characterOffset * Math.PI * 2.0;
            double blue = (Math.sin(timeOffset + bluePhase) * 0.35 + 0.65) * 100.0 + 155.0;
            double red = (Math.sin(timeOffset + pinkPhase) * 0.25 + 0.55) * 80.0 + 140.0;
            double green = (Math.sin(timeOffset + purplePhase) * 0.3 + 0.5) * 70.0 + 110.0;
            double brightnessModulation = 0.9 + 0.1 * Math.sin(preciseTime * 1.0 + (double)i * 0.15);
            red = Math.min(220.0, red * brightnessModulation);
            green = Math.min(180.0, green * brightnessModulation);
            blue = Math.min(255.0, blue * brightnessModulation);
            int finalRed = Math.max(140, Math.min(220, (int)Math.round(red)));
            int finalGreen = Math.max(110, Math.min(180, (int)Math.round(green)));
            int finalBlue = Math.max(155, Math.min(255, (int)Math.round(blue)));
            int color = finalRed << 16 | finalGreen << 8 | finalBlue;
            coloredText.m_7220_((Component)Component.m_237113_((String)String.valueOf(c)).m_130948_(Style.f_131099_.m_178520_(color)));
        }
        if (index < tooltip.size()) {
            tooltip.add(index, (Component)coloredText.m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
        } else {
            tooltip.add((Component)coloredText.m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
        }
    }
}

