/*
 * Decompiled with CFR 0.152.
 */
package silly.homak.betterlightmap.mixin;

import net.minecraft.class_1011;
import net.minecraft.class_765;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_765.class})
public class LightmapTextureManagerMixin {
    private static final float BASE_TINT = 0.25f;
    private static final float DARK_EXTRA = 0.5f;
    private static final float BRIGHT_R = 0.95f;
    private static final float BRIGHT_G = 0.5f;
    private static final float BRIGHT_B = 0.15f;
    private static final float DARK_R = 0.15f;
    private static final float DARK_G = 0.18f;
    private static final float DARK_B = 0.4f;

    private int applyTintBlockLight(class_1011 image, int x, int y, int colorPacked) {
        if (x == 15 && y == 15) {
            return colorPacked;
        }
        int a = colorPacked >>> 24 & 0xFF;
        int b = colorPacked >>> 16 & 0xFF;
        int g = colorPacked >>> 8 & 0xFF;
        int r = colorPacked & 0xFF;
        float rf = (float)r / 255.0f;
        float gf = (float)g / 255.0f;
        float bf = (float)b / 255.0f;
        float luminance = 0.2126f * rf + 0.7152f * gf + 0.0722f * bf;
        float brightness = Math.max(0.0f, Math.min(1.0f, luminance));
        float darkness = 1.0f - brightness;
        float targetR = x < 16 ? LightmapTextureManagerMixin.lerp(0.15f, 0.95f, brightness) : rf;
        float targetG = x < 16 ? LightmapTextureManagerMixin.lerp(0.18f, 0.5f, brightness) : gf;
        float targetB = x < 16 ? LightmapTextureManagerMixin.lerp(0.4f, 0.15f, brightness) : bf;
        float dynamicTint = 0.25f + 0.5f * darkness;
        rf = LightmapTextureManagerMixin.lerp(rf, targetR, dynamicTint);
        gf = LightmapTextureManagerMixin.lerp(gf, targetG, dynamicTint);
        bf = LightmapTextureManagerMixin.lerp(bf, targetB, dynamicTint);
        if (brightness < 0.12f) {
            float extra = (0.12f - brightness) / 0.12f;
            rf = LightmapTextureManagerMixin.lerp(rf, 0.15f, 0.5f * extra);
            gf = LightmapTextureManagerMixin.lerp(gf, 0.18f, 0.5f * extra);
            bf = LightmapTextureManagerMixin.lerp(bf, 0.4f, 0.5f * extra);
        }
        int nr = LightmapTextureManagerMixin.clamp((int)(rf * 255.0f));
        int ng = LightmapTextureManagerMixin.clamp((int)(gf * 255.0f));
        int nb = LightmapTextureManagerMixin.clamp((int)(bf * 255.0f));
        int newPacked = a << 24 | nb << 16 | ng << 8 | nr;
        image.method_4305(x, y, newPacked);
        return newPacked;
    }

    private static int clamp(int v) {
        if (v < 0) {
            return 0;
        }
        if (v > 255) {
            return 255;
        }
        return v;
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    @Redirect(method={"method_3313(F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_1011;method_4305(III)V"))
    private void redirectSetColor(class_1011 image, int x, int y, int color) {
        this.applyTintBlockLight(image, x, y, color);
    }
}

