/*
 * Decompiled with CFR 0.152.
 */
package silly.homak.betterlightmap.mixin;

import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_1011;
import net.minecraft.class_765;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import silly.homak.betterlightmap.config.LightmapConfig;

@Mixin(value={class_765.class})
public class LightmapTextureManagerMixin {
    @Unique
    private LightmapConfig betterLightmap$config;

    @Unique
    private float[] betterLightmap$getBrightColor() {
        if (this.betterLightmap$config == null) {
            this.betterLightmap$config = (LightmapConfig)AutoConfig.getConfigHolder(LightmapConfig.class).getConfig();
        }
        int color = this.betterLightmap$config.colors.brightColor;
        return new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
    }

    @Unique
    private float[] betterLightmap$getDarkColor() {
        if (this.betterLightmap$config == null) {
            this.betterLightmap$config = (LightmapConfig)AutoConfig.getConfigHolder(LightmapConfig.class).getConfig();
        }
        int color = this.betterLightmap$config.colors.darkColor;
        return new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
    }

    @Unique
    private float betterLightmap$getBrightStrength() {
        if (this.betterLightmap$config == null) {
            this.betterLightmap$config = (LightmapConfig)AutoConfig.getConfigHolder(LightmapConfig.class).getConfig();
        }
        return (float)this.betterLightmap$config.colors.brightStrength / 100.0f;
    }

    @Unique
    private float betterLightmap$getDarkStrength() {
        if (this.betterLightmap$config == null) {
            this.betterLightmap$config = (LightmapConfig)AutoConfig.getConfigHolder(LightmapConfig.class).getConfig();
        }
        return (float)this.betterLightmap$config.colors.darkStrength / 100.0f;
    }

    @Unique
    private boolean betterLightmap$isEnabled() {
        if (this.betterLightmap$config == null) {
            this.betterLightmap$config = (LightmapConfig)AutoConfig.getConfigHolder(LightmapConfig.class).getConfig();
        }
        return this.betterLightmap$config.enabled;
    }

    @Unique
    private int betterLightmap$applyTintBlockLight(class_1011 image, int x, int y, int colorPacked) {
        if (!this.betterLightmap$isEnabled()) {
            image.method_4305(x, y, colorPacked);
            return colorPacked;
        }
        if (x == 15 && y == 15) {
            return colorPacked;
        }
        int a = colorPacked >>> 24 & 0xFF;
        int b = colorPacked >>> 16 & 0xFF;
        int g = colorPacked >>> 8 & 0xFF;
        int r = colorPacked & 0xFF;
        float rf = (float)r / 255.0f;
        float gf = (float)g / 255.0f;
        float bf = (float)b / 255.0f;
        float luminance = 0.2126f * rf + 0.7152f * gf + 0.0722f * bf;
        float brightness = Math.max(0.0f, Math.min(1.0f, luminance));
        float darkness = 1.0f - brightness;
        float[] brightColor = this.betterLightmap$getBrightColor();
        float[] darkColor = this.betterLightmap$getDarkColor();
        float brightStrength = this.betterLightmap$getBrightStrength();
        float darkStrength = this.betterLightmap$getDarkStrength();
        float targetR = x < 16 ? LightmapTextureManagerMixin.betterLightmap$lerp(darkColor[0], brightColor[0], brightness) : rf;
        float targetG = x < 16 ? LightmapTextureManagerMixin.betterLightmap$lerp(darkColor[1], brightColor[1], brightness) : gf;
        float targetB = x < 16 ? LightmapTextureManagerMixin.betterLightmap$lerp(darkColor[2], brightColor[2], brightness) : bf;
        float dynamicTint = brightStrength + darkStrength * darkness;
        rf = LightmapTextureManagerMixin.betterLightmap$lerp(rf, targetR, dynamicTint);
        gf = LightmapTextureManagerMixin.betterLightmap$lerp(gf, targetG, dynamicTint);
        bf = LightmapTextureManagerMixin.betterLightmap$lerp(bf, targetB, dynamicTint);
        if (brightness < 0.12f) {
            float extra = (0.12f - brightness) / 0.12f;
            rf = LightmapTextureManagerMixin.betterLightmap$lerp(rf, darkColor[0], 0.5f * extra);
            gf = LightmapTextureManagerMixin.betterLightmap$lerp(gf, darkColor[1], 0.5f * extra);
            bf = LightmapTextureManagerMixin.betterLightmap$lerp(bf, darkColor[2], 0.5f * extra);
        }
        int nr = LightmapTextureManagerMixin.betterLightmap$clamp((int)(rf * 255.0f));
        int ng = LightmapTextureManagerMixin.betterLightmap$clamp((int)(gf * 255.0f));
        int nb = LightmapTextureManagerMixin.betterLightmap$clamp((int)(bf * 255.0f));
        int newPacked = a << 24 | nb << 16 | ng << 8 | nr;
        image.method_4305(x, y, newPacked);
        return newPacked;
    }

    @Unique
    private static int betterLightmap$clamp(int v) {
        if (v < 0) {
            return 0;
        }
        if (v > 255) {
            return 255;
        }
        return v;
    }

    @Unique
    private static float betterLightmap$lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    @Redirect(method={"method_3313(F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_1011;method_4305(III)V"))
    private void redirectSetColor(class_1011 image, int x, int y, int color) {
        this.betterLightmap$applyTintBlockLight(image, x, y, color);
    }
}

