/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.client.gui;

import com.daqem.uilib.gui.component.AbstractComponent;
import com.daqem.yamlconfig.api.config.IConfig;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.IStackConfigEntry;
import com.daqem.yamlconfig.client.gui.component.ConfigCategoryComponent;
import com.daqem.yamlconfig.client.gui.component.entry.YamlOnlyConfigEntryComponent;
import com.daqem.yamlconfig.client.gui.registry.ConfigEntryComponentRegistry;
import com.daqem.yamlconfig.client.gui.registry.IConfigEntryComponentFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class ConfigEntryComponentBuilder {
    private final IConfig config;

    public ConfigEntryComponentBuilder(IConfig config) {
        this.config = config;
    }

    public ConfigCategoryComponent build() {
        return this.buildCategory(null, "", this.config.getContext());
    }

    private ConfigCategoryComponent buildCategory(String key, String prefix, IStackConfigEntry stackEntry) {
        ArrayList<AbstractComponent> children = new ArrayList<AbstractComponent>();
        for (Map.Entry entry : ((LinkedHashMap)stackEntry.get()).entrySet()) {
            String fullPath;
            String entryKey = (String)entry.getKey();
            IConfigEntry configEntry = (IConfigEntry)entry.getValue();
            String string = fullPath = prefix.isEmpty() ? entryKey : prefix + entryKey;
            if (configEntry instanceof IStackConfigEntry) {
                IStackConfigEntry subStack = (IStackConfigEntry)configEntry;
                children.add(this.buildCategory(entryKey, fullPath + ".", subStack));
                continue;
            }
            children.add(this.createTypedEntryComponent(fullPath, configEntry));
        }
        String labelKey = key == null ? null : this.config.getModId() + "." + this.config.getName() + "." + prefix.substring(0, prefix.length() - 1);
        return new ConfigCategoryComponent(stackEntry, labelKey, children);
    }

    private <T> AbstractComponent createTypedEntryComponent(String key, IConfigEntry<T> entry) {
        String translationKey = this.config.getModId() + "." + this.config.getName() + "." + key;
        IConfigEntryComponentFactory<IConfigEntry<T>> factory = ConfigEntryComponentRegistry.getFactory(entry.getType());
        if (factory != null) {
            return (AbstractComponent)factory.create(translationKey, entry);
        }
        return new YamlOnlyConfigEntryComponent(translationKey, entry);
    }
}

