/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.client.gui.component;

import com.daqem.uilib.api.component.IComponent;
import com.daqem.uilib.gui.component.AbstractComponent;
import com.daqem.yamlconfig.api.config.entry.IStackConfigEntry;
import com.daqem.yamlconfig.api.gui.component.IConfigEntryComponent;
import com.daqem.yamlconfig.client.gui.component.TruncatedKeyTextComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.Nullable;

public class ConfigCategoryComponent
extends AbstractComponent {
    @Nullable
    private final String key;
    private final List<AbstractComponent> children;

    public ConfigCategoryComponent(IStackConfigEntry stackConfigEntry, @Nullable String key, List<AbstractComponent> children) {
        super(0, 0, 314, 0);
        this.key = key;
        this.children = children;
        if (key != null) {
            this.addComponent((IComponent)new TruncatedKeyTextComponent(key, this.getWidth(), stackConfigEntry, true));
        }
        this.addComponents(children);
    }

    public int getWidth() {
        return 314;
    }

    public int getHeight() {
        int height = 0;
        if (this.key != null) {
            Objects.requireNonNull(Minecraft.getInstance().font);
            height += 9 + 12;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            AbstractComponent child = this.children.get(i);
            height += child.getHeight();
            if (i >= this.children.size() - 1) continue;
            height += 10;
        }
        return height;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        this.renderHorizontalLines(guiGraphics);
        int currentY = 0;
        if (this.key != null) {
            Objects.requireNonNull(Minecraft.getInstance().font);
            currentY += 9 + 12;
        }
        for (AbstractComponent child : this.children) {
            child.setY(currentY);
            child.render(guiGraphics, mouseX, mouseY, partialTick, parentWidth, parentHeight);
            currentY += child.getHeight() + 10;
        }
    }

    private void renderHorizontalLines(GuiGraphics graphics) {
        if (this.key == null) {
            return;
        }
        Objects.requireNonNull(Minecraft.getInstance().font);
        int lineYStart = 9 + 6;
        graphics.fill(this.getTotalX(), this.getTotalY() + lineYStart, this.getTotalX() + this.getWidth(), this.getTotalY() + lineYStart + 1, -1);
    }

    public List<IConfigEntryComponent<?>> getAllConfigEntryComponents() {
        ArrayList allComponents = new ArrayList();
        for (AbstractComponent child : this.children) {
            if (child instanceof IConfigEntryComponent) {
                IConfigEntryComponent entryComponent = (IConfigEntryComponent)child;
                allComponents.add(entryComponent);
                continue;
            }
            if (!(child instanceof ConfigCategoryComponent)) continue;
            ConfigCategoryComponent categoryComponent = (ConfigCategoryComponent)child;
            allComponents.addAll(categoryComponent.getAllConfigEntryComponents());
        }
        return allComponents;
    }
}

