/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.client.gui.component.entry;

import com.daqem.uilib.api.widget.IWidget;
import com.daqem.uilib.gui.widget.EditBoxWidget;
import com.daqem.uilib.util.ValidationErrors;
import com.daqem.yamlconfig.api.config.entry.IDateTimeConfigEntry;
import com.daqem.yamlconfig.client.gui.component.entry.BaseConfigEntryComponent;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;

public class DateTimeConfigEntryComponent
extends BaseConfigEntryComponent<IDateTimeConfigEntry> {
    private final EditBoxWidget editBoxWidget;

    public DateTimeConfigEntryComponent(String key, IDateTimeConfigEntry configEntry) {
        super(key, configEntry, 0, 0, 20);
        this.editBoxWidget = new EditBoxWidget(this, Minecraft.getInstance().font, 140, 0, 150, 20, (Component)Component.empty()){

            public List<Component> validateInput(String input) {
                List list = super.validateInput(input);
                try {
                    IDateTimeConfigEntry.DATE_TIME_FORMATTER.parse(input);
                }
                catch (Exception e) {
                    list.add(ValidationErrors.invalidDateTime((String)"yyyy-MM-dd HH:mm:ss"));
                }
                return list;
            }
        };
        this.editBoxWidget.setValue(IDateTimeConfigEntry.DATE_TIME_FORMATTER.format((TemporalAccessor)configEntry.get()));
        this.editBoxWidget.setMaxLength(19);
        this.addWidget((IWidget)this.editBoxWidget);
    }

    @Override
    public boolean isOriginalValue() {
        return ((LocalDateTime)((IDateTimeConfigEntry)this.getConfigEntry()).getDefaultValue()).format(IDateTimeConfigEntry.DATE_TIME_FORMATTER).equals(this.editBoxWidget.getValue());
    }

    @Override
    public void resetValue() {
        this.editBoxWidget.setValue(((LocalDateTime)((IDateTimeConfigEntry)this.getConfigEntry()).getDefaultValue()).format(IDateTimeConfigEntry.DATE_TIME_FORMATTER));
    }

    @Override
    public void applyValue() {
        if (this.editBoxWidget.hasInputValidationErrors()) {
            return;
        }
        ((IDateTimeConfigEntry)this.getConfigEntry()).set(LocalDateTime.parse(this.editBoxWidget.getValue(), IDateTimeConfigEntry.DATE_TIME_FORMATTER));
    }

    @Override
    public boolean hasValidationErrors() {
        return this.editBoxWidget.hasInputValidationErrors();
    }
}

