/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.client.gui.component.entry.list.numeric;

import com.daqem.uilib.util.ValidationErrors;
import com.daqem.yamlconfig.api.config.entry.list.numeric.IDoubleListConfigEntry;
import com.daqem.yamlconfig.client.gui.component.entry.list.BaseListConfigEntryComponent;
import java.util.ArrayList;
import net.minecraft.network.chat.MutableComponent;

public class DoubleListConfigEntryComponent
extends BaseListConfigEntryComponent<IDoubleListConfigEntry> {
    public DoubleListConfigEntryComponent(String key, IDoubleListConfigEntry configEntry) {
        super(key, configEntry, input -> {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            try {
                double value = Double.parseDouble(input);
                if (value < (Double)configEntry.getMinValue()) {
                    list.add(ValidationErrors.minValue(configEntry.getMinValue()));
                }
                if (value > (Double)configEntry.getMaxValue()) {
                    list.add(ValidationErrors.maxValue(configEntry.getMaxValue()));
                }
            }
            catch (NumberFormatException e) {
                list.add(ValidationErrors.invalidNumber());
            }
            return list;
        });
    }

    @Override
    public void applyValue() {
        if (this.hasInputValidationErrors()) {
            return;
        }
        ((IDoubleListConfigEntry)this.getConfigEntry()).set(this.editBoxWidgets.keySet().stream().map(input -> Double.parseDouble(input.getValue())).toList());
    }
}

