/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.client.gui.component.entry.list.numeric;

import com.daqem.uilib.util.ValidationErrors;
import com.daqem.yamlconfig.api.config.entry.list.numeric.IFloatListConfigEntry;
import com.daqem.yamlconfig.client.gui.component.entry.list.BaseListConfigEntryComponent;
import java.util.ArrayList;
import net.minecraft.network.chat.MutableComponent;

public class FloatListConfigEntryComponent
extends BaseListConfigEntryComponent<IFloatListConfigEntry> {
    public FloatListConfigEntryComponent(String key, IFloatListConfigEntry configEntry) {
        super(key, configEntry, input -> {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            try {
                double value = Float.parseFloat(input);
                if (value < (double)((Float)configEntry.getMinValue()).floatValue()) {
                    list.add(ValidationErrors.minValue(configEntry.getMinValue()));
                }
                if (value > (double)((Float)configEntry.getMaxValue()).floatValue()) {
                    list.add(ValidationErrors.maxValue(configEntry.getMaxValue()));
                }
            }
            catch (NumberFormatException e) {
                list.add(ValidationErrors.invalidNumber());
            }
            return list;
        });
    }

    @Override
    public void applyValue() {
        if (this.hasInputValidationErrors()) {
            return;
        }
        ((IFloatListConfigEntry)this.getConfigEntry()).set(this.editBoxWidgets.keySet().stream().map(input -> Float.valueOf(Float.parseFloat(input.getValue()))).toList());
    }
}

