/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.client.gui.component.entry.list.numeric;

import com.daqem.uilib.util.ValidationErrors;
import com.daqem.yamlconfig.api.config.entry.list.numeric.IIntegerListConfigEntry;
import com.daqem.yamlconfig.client.gui.component.entry.list.BaseListConfigEntryComponent;
import java.util.ArrayList;
import net.minecraft.network.chat.MutableComponent;

public class IntegerListConfigEntryComponent
extends BaseListConfigEntryComponent<IIntegerListConfigEntry> {
    public IntegerListConfigEntryComponent(String key, IIntegerListConfigEntry configEntry) {
        super(key, configEntry, input -> {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            try {
                int value = Integer.parseInt(input);
                if (value < (Integer)configEntry.getMinValue()) {
                    list.add(ValidationErrors.minValue(configEntry.getMinValue()));
                }
                if (value > (Integer)configEntry.getMaxValue()) {
                    list.add(ValidationErrors.maxValue(configEntry.getMaxValue()));
                }
            }
            catch (NumberFormatException e) {
                list.add(ValidationErrors.invalidNumber());
            }
            return list;
        });
    }

    @Override
    public void applyValue() {
        if (this.hasInputValidationErrors()) {
            return;
        }
        ((IIntegerListConfigEntry)this.getConfigEntry()).set(this.editBoxWidgets.keySet().stream().map(input -> Integer.parseInt(input.getValue())).toList());
    }
}

