/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.client.gui.component.entry.map.numeric;

import com.daqem.uilib.gui.widget.EditBoxWidget;
import com.daqem.uilib.util.ValidationErrors;
import com.daqem.yamlconfig.api.config.entry.map.numeric.IDoubleMapConfigEntry;
import com.daqem.yamlconfig.client.gui.component.entry.map.BaseMapConfigEntryComponent;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.chat.MutableComponent;

public class DoubleMapConfigEntryComponent
extends BaseMapConfigEntryComponent<IDoubleMapConfigEntry> {
    public DoubleMapConfigEntryComponent(String key, IDoubleMapConfigEntry configEntry) {
        super(key, configEntry, input -> {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            try {
                double value = Double.parseDouble(input);
                if (value < (Double)configEntry.getMinValue()) {
                    list.add(ValidationErrors.minValue(configEntry.getMinValue()));
                }
                if (value > (Double)configEntry.getMaxValue()) {
                    list.add(ValidationErrors.maxValue(configEntry.getMaxValue()));
                }
            }
            catch (NumberFormatException e) {
                list.add(ValidationErrors.invalidNumber());
            }
            return list;
        });
    }

    @Override
    public void applyValue() {
        if (this.hasInputValidationErrors()) {
            return;
        }
        Map<String, Double> map = this.editBoxWidgets.keySet().stream().collect(Collectors.toMap(entry -> ((EditBoxWidget)entry.getA()).getValue(), entry -> Double.parseDouble(((EditBoxWidget)entry.getB()).getValue())));
        ((IDoubleMapConfigEntry)this.getConfigEntry()).set(map);
    }
}

