/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.client.gui.component.entry.map.numeric;

import com.daqem.uilib.gui.widget.EditBoxWidget;
import com.daqem.uilib.util.ValidationErrors;
import com.daqem.yamlconfig.api.config.entry.map.numeric.IFloatMapConfigEntry;
import com.daqem.yamlconfig.client.gui.component.entry.map.BaseMapConfigEntryComponent;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.chat.MutableComponent;

public class FloatMapConfigEntryComponent
extends BaseMapConfigEntryComponent<IFloatMapConfigEntry> {
    public FloatMapConfigEntryComponent(String key, IFloatMapConfigEntry configEntry) {
        super(key, configEntry, input -> {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            try {
                double value = Float.parseFloat(input);
                if (value < (double)((Float)configEntry.getMinValue()).floatValue()) {
                    list.add(ValidationErrors.minValue(configEntry.getMinValue()));
                }
                if (value > (double)((Float)configEntry.getMaxValue()).floatValue()) {
                    list.add(ValidationErrors.maxValue(configEntry.getMaxValue()));
                }
            }
            catch (NumberFormatException e) {
                list.add(ValidationErrors.invalidNumber());
            }
            return list;
        });
    }

    @Override
    public void applyValue() {
        if (this.hasInputValidationErrors()) {
            return;
        }
        Map<String, Float> map = this.editBoxWidgets.keySet().stream().collect(Collectors.toMap(entry -> ((EditBoxWidget)entry.getA()).getValue(), entry -> Float.valueOf(Float.parseFloat(((EditBoxWidget)entry.getB()).getValue()))));
        ((IFloatMapConfigEntry)this.getConfigEntry()).set(map);
    }
}

