/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.client.gui.component.entry.minecraft;

import com.daqem.uilib.api.widget.IWidget;
import com.daqem.uilib.gui.widget.EditBoxWidget;
import com.daqem.uilib.util.ValidationErrors;
import com.daqem.yamlconfig.api.config.entry.minecraft.IIdentifierConfigEntry;
import com.daqem.yamlconfig.client.gui.component.entry.BaseConfigEntryComponent;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;

public class IdentifierConfigEntryComponent
extends BaseConfigEntryComponent<IIdentifierConfigEntry> {
    private final EditBoxWidget editBoxWidget;

    public IdentifierConfigEntryComponent(String key, final IIdentifierConfigEntry configEntry) {
        super(key, configEntry, 0, 0, 20);
        this.editBoxWidget = new EditBoxWidget(this, Minecraft.getInstance().font, 140, 0, 150, 20, (Component)Component.empty()){

            public List<Component> validateInput(String input) {
                List list = super.validateInput(input);
                Identifier value = Identifier.tryParse((String)input);
                if (value == null || value.getPath().isEmpty() || value.getNamespace().isEmpty() || value.getPath().contains(" ") || value.getNamespace().contains(" ")) {
                    list.add(ValidationErrors.invalidIdentifier());
                } else if (configEntry.getPattern() != null && !input.matches(configEntry.getPattern())) {
                    list.add(ValidationErrors.pattern((String)configEntry.getPattern()));
                }
                return list;
            }
        };
        this.editBoxWidget.setValue(((Identifier)configEntry.get()).toString());
        this.editBoxWidget.setMaxLength(256);
        this.addWidget((IWidget)this.editBoxWidget);
    }

    @Override
    public boolean isOriginalValue() {
        return ((Identifier)((IIdentifierConfigEntry)this.getConfigEntry()).getDefaultValue()).equals((Object)Identifier.tryParse((String)this.editBoxWidget.getValue()));
    }

    @Override
    public void resetValue() {
        this.editBoxWidget.setValue(((Identifier)((IIdentifierConfigEntry)this.getConfigEntry()).getDefaultValue()).toString());
    }

    @Override
    public void applyValue() {
        if (this.editBoxWidget.hasInputValidationErrors()) {
            return;
        }
        ((IIdentifierConfigEntry)this.getConfigEntry()).set(Identifier.tryParse((String)this.editBoxWidget.getValue()));
    }

    @Override
    public boolean hasValidationErrors() {
        return this.editBoxWidget.hasInputValidationErrors();
    }
}

