/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.client.gui.component.entry.minecraft;

import com.daqem.uilib.api.widget.IWidget;
import com.daqem.uilib.gui.widget.EditBoxWidget;
import com.daqem.uilib.util.ValidationErrors;
import com.daqem.yamlconfig.api.config.entry.minecraft.IRegistryConfigEntry;
import com.daqem.yamlconfig.client.gui.component.entry.BaseConfigEntryComponent;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;

public class RegistryConfigEntryComponent<T>
extends BaseConfigEntryComponent<IRegistryConfigEntry<T>> {
    private final EditBoxWidget editBoxWidget;

    public RegistryConfigEntryComponent(String key, IRegistryConfigEntry<T> configEntry) {
        super(key, configEntry, 0, 0, 20);
        this.editBoxWidget = new EditBoxWidget(Minecraft.getInstance().font, 140, 0, 150, 20, (Component)Component.empty()){

            public List<Component> validateInput(String input) {
                List list = super.validateInput(input);
                Identifier value = Identifier.tryParse((String)input);
                if (value == null || value.getPath().isEmpty() || value.getNamespace().isEmpty() || value.getPath().contains(" ") || value.getNamespace().contains(" ")) {
                    list.add(ValidationErrors.invalidIdentifier());
                } else if (!((IRegistryConfigEntry)RegistryConfigEntryComponent.this.getConfigEntry()).getRegistry().keySet().contains(value)) {
                    list.add(ValidationErrors.invalidRegistryValue());
                }
                return list;
            }
        };
        Identifier resourceLocation = ((IRegistryConfigEntry)this.getConfigEntry()).getRegistry().getKey(((IRegistryConfigEntry)this.getConfigEntry()).get());
        String stringValue = resourceLocation != null ? resourceLocation.toString() : "unknown";
        this.editBoxWidget.setValue(stringValue);
        this.editBoxWidget.setMaxLength(256);
        this.addWidget((IWidget)this.editBoxWidget);
    }

    @Override
    public boolean isOriginalValue() {
        Object defaultValue = ((IRegistryConfigEntry)this.getConfigEntry()).getDefaultValue();
        Optional value = ((IRegistryConfigEntry)this.getConfigEntry()).getRegistry().get(Identifier.parse((String)this.editBoxWidget.getValue()));
        return value.isPresent() && defaultValue == ((Holder.Reference)value.get()).value();
    }

    @Override
    public void resetValue() {
        Identifier resourceLocation = ((IRegistryConfigEntry)this.getConfigEntry()).getRegistry().getKey(((IRegistryConfigEntry)this.getConfigEntry()).getDefaultValue());
        String stringValue = resourceLocation != null ? resourceLocation.toString() : "unknown";
        this.editBoxWidget.setValue(stringValue);
    }

    @Override
    public void applyValue() {
        if (this.editBoxWidget.hasInputValidationErrors()) {
            return;
        }
        Optional reference = ((IRegistryConfigEntry)this.getConfigEntry()).getRegistry().get(Identifier.parse((String)this.editBoxWidget.getValue()));
        reference.ifPresent(tReference -> ((IRegistryConfigEntry)this.getConfigEntry()).set(tReference.value()));
    }

    @Override
    public boolean hasValidationErrors() {
        return this.editBoxWidget.hasInputValidationErrors();
    }
}

