/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.client.gui.component.entry.numeric;

import com.daqem.uilib.api.widget.IWidget;
import com.daqem.uilib.gui.widget.EditBoxWidget;
import com.daqem.yamlconfig.api.config.entry.numeric.INumericConfigEntry;
import com.daqem.yamlconfig.api.gui.component.IComponentValidator;
import com.daqem.yamlconfig.client.gui.component.entry.BaseConfigEntryComponent;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;

public abstract class BaseNumericConfigEntryComponent<C extends INumericConfigEntry<N>, N extends Number>
extends BaseConfigEntryComponent<C> {
    protected final EditBoxWidget editBoxWidget;

    public BaseNumericConfigEntryComponent(String key, C configEntry, final IComponentValidator validator) {
        super(key, configEntry, 0, 0, 20);
        this.editBoxWidget = new EditBoxWidget(this, Minecraft.getInstance().font, 140, 0, 150, 20, (Component)Component.empty()){

            public List<Component> validateInput(String input) {
                return validator.validate(input);
            }
        };
        this.editBoxWidget.setValue(((Number)configEntry.get()).toString());
        this.editBoxWidget.setMaxLength(32);
        this.addWidget((IWidget)this.editBoxWidget);
    }

    @Override
    public boolean isOriginalValue() {
        try {
            return ((Number)((INumericConfigEntry)this.getConfigEntry()).getDefaultValue()).toString().equals(this.editBoxWidget.getValue());
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void resetValue() {
        this.editBoxWidget.setValue(((Number)((INumericConfigEntry)this.getConfigEntry()).getDefaultValue()).toString());
    }

    @Override
    public boolean hasValidationErrors() {
        return this.editBoxWidget.hasInputValidationErrors();
    }
}

