/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.client.gui.component.entry.numeric;

import com.daqem.uilib.util.ValidationErrors;
import com.daqem.yamlconfig.api.config.entry.numeric.IIntegerConfigEntry;
import com.daqem.yamlconfig.client.gui.component.entry.numeric.BaseNumericConfigEntryComponent;
import java.util.ArrayList;
import net.minecraft.network.chat.MutableComponent;

public class IntegerConfigEntryComponent
extends BaseNumericConfigEntryComponent<IIntegerConfigEntry, Integer> {
    public IntegerConfigEntryComponent(String key, IIntegerConfigEntry configEntry) {
        super(key, configEntry, input -> {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            try {
                int value = Integer.parseInt(input);
                if (value < (Integer)configEntry.getMinValue()) {
                    list.add(ValidationErrors.minValue(configEntry.getMinValue()));
                }
                if (value > (Integer)configEntry.getMaxValue()) {
                    list.add(ValidationErrors.maxValue(configEntry.getMaxValue()));
                }
            }
            catch (NumberFormatException e) {
                list.add(ValidationErrors.invalidNumber());
            }
            return list;
        });
    }

    @Override
    public void applyValue() {
        if (this.editBoxWidget.hasInputValidationErrors()) {
            return;
        }
        ((IIntegerConfigEntry)this.getConfigEntry()).set(Integer.parseInt(this.editBoxWidget.getValue()));
    }
}

