/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.client.gui.component.entry.numeric;

import com.daqem.uilib.util.ValidationErrors;
import com.daqem.yamlconfig.api.config.entry.numeric.ILongConfigEntry;
import com.daqem.yamlconfig.client.gui.component.entry.numeric.BaseNumericConfigEntryComponent;
import java.util.ArrayList;
import net.minecraft.network.chat.MutableComponent;

public class LongConfigEntryComponent
extends BaseNumericConfigEntryComponent<ILongConfigEntry, Long> {
    public LongConfigEntryComponent(String key, ILongConfigEntry configEntry) {
        super(key, configEntry, input -> {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            try {
                long value = Long.parseLong(input);
                if (value < (Long)configEntry.getMinValue()) {
                    list.add(ValidationErrors.minValue(configEntry.getMinValue()));
                }
                if (value > (Long)configEntry.getMaxValue()) {
                    list.add(ValidationErrors.maxValue(configEntry.getMaxValue()));
                }
            }
            catch (NumberFormatException e) {
                list.add(ValidationErrors.invalidNumber());
            }
            return list;
        });
    }

    @Override
    public void applyValue() {
        if (this.editBoxWidget.hasInputValidationErrors()) {
            return;
        }
        ((ILongConfigEntry)this.getConfigEntry()).set(Long.parseLong(this.editBoxWidget.getValue()));
    }
}

