/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config;

import com.daqem.yamlconfig.YamlConfig;
import com.daqem.yamlconfig.api.config.ConfigExtension;
import com.daqem.yamlconfig.api.config.ConfigType;
import com.daqem.yamlconfig.api.config.IConfig;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.IStackConfigEntry;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.api.config.serializer.IConfigSerializer;
import com.daqem.yamlconfig.api.format.IConfigFormat;
import com.daqem.yamlconfig.api.node.IConfigNode;
import com.daqem.yamlconfig.api.node.IMapNode;
import com.daqem.yamlconfig.impl.config.ClientConfig;
import com.daqem.yamlconfig.impl.config.CommonConfig;
import com.daqem.yamlconfig.impl.config.ServerConfig;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import com.daqem.yamlconfig.impl.node.ConfigMapNode;
import com.mojang.datafixers.util.Function5;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;

public abstract class BaseConfig
implements IConfig {
    private final String modId;
    private final String name;
    private final ConfigExtension extension;
    private final ConfigType type;
    private final Path path;
    private final IStackConfigEntry context;
    private boolean isSynced = false;
    public static final StreamCodec<RegistryFriendlyByteBuf, BaseConfig> STREAM_CODEC = StreamCodec.of((buf, config) -> {
        buf.writeEnum((Enum)config.getType());
        buf.writeUtf(config.getModId());
        buf.writeUtf(config.getName());
        buf.writeEnum((Enum)config.getExtension());
        buf.writeUtf(config.getPath().toString());
    }, buf -> {
        ConfigType type = (ConfigType)buf.readEnum(ConfigType.class);
        String modId = buf.readUtf();
        String name = buf.readUtf();
        ConfigExtension extension = (ConfigExtension)buf.readEnum(ConfigExtension.class);
        Path path = Path.of(buf.readUtf(), new String[0]);
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ConfigType.CLIENT -> new ClientConfig(modId, name, extension, path, null);
            case ConfigType.COMMON -> new CommonConfig(modId, name, extension, path, null);
            case ConfigType.SERVER -> new ServerConfig(modId, name, extension, path, null);
        };
    });

    public BaseConfig(String modId, String name, ConfigExtension extension, ConfigType type, Path path, IStackConfigEntry context) {
        this.modId = modId;
        this.name = name;
        this.extension = extension;
        this.type = type;
        this.path = path;
        this.context = context;
    }

    @Override
    public void load() {
        IConfigFormat format = this.extension.createFormat();
        File file = new File(this.path.toFile(), this.name + this.extension.getExtension());
        if (!file.exists()) {
            YamlConfig.LOGGER.info("Config file not found, creating default: {}{}", (Object)this.name, (Object)this.extension.getExtension());
            this.save();
            return;
        }
        try (FileReader reader = new FileReader(file);){
            IMapNode rootNode = format.read(reader);
            this.deserializeFromNode(rootNode, this.context);
            this.setSynced(false);
            YamlConfig.LOGGER.info("Loaded config file: {}{}", (Object)this.name, (Object)this.extension.getExtension());
        }
        catch (Exception e) {
            YamlConfig.LOGGER.error("Failed to load config file: {}{}", new Object[]{this.name, this.extension.getExtension(), e});
        }
    }

    private void deserializeFromNode(IMapNode parent, IStackConfigEntry stack) {
        for (Map.Entry entrySet : ((LinkedHashMap)stack.get()).entrySet()) {
            String key = (String)entrySet.getKey();
            IConfigEntry entry = (IConfigEntry)entrySet.getValue();
            if (!parent.containsKey(key)) continue;
            if (entry instanceof IStackConfigEntry) {
                IStackConfigEntry childStack = (IStackConfigEntry)entry;
                IConfigNode node = parent.get(key);
                if (!(node instanceof IMapNode)) continue;
                IMapNode mapNode = (IMapNode)node;
                this.deserializeFromNode(mapNode, childStack);
                continue;
            }
            this.deserializeEntry(entry, parent);
        }
    }

    private <T> void deserializeEntry(IConfigEntry<T> entry, IMapNode parent) {
        entry.getType().getSerializer().fromNode(entry, parent);
    }

    @Override
    public void save() {
        IConfigFormat format = this.extension.createFormat();
        File file = new File(this.path.toFile(), this.name + this.extension.getExtension());
        if (file.getParentFile() != null && !file.getParentFile().mkdirs() && !file.getParentFile().exists()) {
            YamlConfig.LOGGER.error("Failed to create config directory: {}", (Object)file.getParentFile().getAbsolutePath());
            return;
        }
        try (FileWriter writer = new FileWriter(file);){
            ConfigMapNode rootNode = new ConfigMapNode();
            this.serializeToNode(rootNode, this.context);
            format.write(writer, rootNode);
            YamlConfig.LOGGER.info("Saved config file: {}{}", (Object)this.name, (Object)this.extension.getExtension());
        }
        catch (Exception e) {
            YamlConfig.LOGGER.error("Failed to save config file: {}{}", new Object[]{this.name, this.extension.getExtension(), e});
        }
    }

    private void serializeToNode(IMapNode parent, IStackConfigEntry stack) {
        for (IConfigEntry entry : ((LinkedHashMap)stack.get()).values()) {
            if (entry instanceof IStackConfigEntry) {
                IStackConfigEntry childStack = (IStackConfigEntry)entry;
                ConfigMapNode childNode = new ConfigMapNode();
                childNode.setComments(childStack.getComments().getComments());
                this.serializeToNode(childNode, childStack);
                parent.put(childStack.getKey(), childNode);
                continue;
            }
            this.serializeEntry(entry, parent);
        }
    }

    private <T> void serializeEntry(IConfigEntry<T> entry, IMapNode parent) {
        entry.getType().getSerializer().toNode(entry, parent);
    }

    @Override
    public void sync(Map<String, ?> data) {
        if (data == null) {
            return;
        }
        for (Map.Entry<String, IConfigEntry<?>> entry : this.getSyncEntries().entrySet()) {
            if (!data.containsKey(entry.getKey())) continue;
            this.setEntryValue(entry.getValue(), data.get(entry.getKey()));
        }
        this.setSynced(true);
    }

    private <T> void setEntryValue(IConfigEntry<T> entry, Object value) {
        try {
            entry.set(value);
        }
        catch (ClassCastException e) {
            YamlConfig.LOGGER.error("Failed to sync config entry: {}", (Object)entry.getKey(), (Object)e);
        }
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ConfigExtension getExtension() {
        return this.extension;
    }

    @Override
    public ConfigType getType() {
        return this.type;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public IStackConfigEntry getContext() {
        return this.context;
    }

    @Override
    public Map<String, IConfigEntry<?>> getEntries() {
        return this.context.getEntries();
    }

    @Override
    public Map<String, IConfigEntry<?>> getSyncEntries() {
        return this.context.getEntries().entrySet().stream().filter(entry -> ((IConfigEntry)entry.getValue()).shouldBeSynced()).collect(HashMap::new, (map, entry) -> map.put((String)entry.getKey(), (IConfigEntry)entry.getValue()), Map::putAll);
    }

    @Override
    public boolean isSynced() {
        return this.isSynced;
    }

    @Override
    public void setSynced(boolean synced) {
        this.isSynced = synced;
    }

    @Override
    public Component getDisplayName() {
        return YamlConfig.translatable(this.modId + "." + this.name);
    }

    @Override
    public Component getModName() {
        return YamlConfig.translatable(this.modId);
    }

    @Override
    public void updateEntries(Map<String, IConfigEntry<?>> entries) {
        LinkedHashMap<String, IConfigEntry<?>> existingEntries = this.context.getEntries();
        for (Map.Entry<String, IConfigEntry<?>> entry : entries.entrySet()) {
            IConfigEntry<?> existingEntry;
            if (!existingEntries.containsKey(entry.getKey()) || !(existingEntry = existingEntries.get(entry.getKey())).getType().equals(entry.getValue().getType())) continue;
            existingEntry.set(entry.getValue().get());
        }
    }

    public static class BaseConfigSerializer<T extends IConfig>
    implements IConfigSerializer<T> {
        private final Function5<String, String, ConfigExtension, Path, IStackConfigEntry, T> configConstructor;

        public BaseConfigSerializer(Function5<String, String, ConfigExtension, Path, IStackConfigEntry, T> configConstructor) {
            this.configConstructor = configConstructor;
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf buf, T config) {
            buf.writeUtf(config.getModId());
            buf.writeUtf(config.getName());
            buf.writeEnum((Enum)config.getExtension());
            buf.writeUtf(config.getPath().toString());
            IConfigEntryType<IStackConfigEntry, LinkedHashMap<String, IConfigEntry<?>>> type = ConfigEntryTypes.STACK;
            type.getSerializer().toNetwork(buf, config.getContext());
        }

        @Override
        public T fromNetwork(RegistryFriendlyByteBuf buf) {
            String modId = buf.readUtf();
            String name = buf.readUtf();
            ConfigExtension extension = (ConfigExtension)buf.readEnum(ConfigExtension.class);
            Path path = Path.of(buf.readUtf(), new String[0]);
            IConfigEntryType<IStackConfigEntry, LinkedHashMap<String, IConfigEntry<?>>> type = ConfigEntryTypes.STACK;
            IStackConfigEntry context = type.getSerializer().fromNetwork(buf);
            return (T)((IConfig)this.configConstructor.apply((Object)modId, (Object)name, (Object)extension, (Object)path, (Object)context));
        }
    }
}

