/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry;

import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.IDateTimeConfigEntry;
import com.daqem.yamlconfig.api.config.entry.comment.IComments;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.api.exception.ConfigEntryValidationException;
import com.daqem.yamlconfig.api.node.IConfigNode;
import com.daqem.yamlconfig.api.node.IMapNode;
import com.daqem.yamlconfig.api.node.IValueNode;
import com.daqem.yamlconfig.impl.config.entry.BaseConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import com.daqem.yamlconfig.impl.node.ConfigValueNode;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class DateTimeConfigEntry
extends BaseConfigEntry<LocalDateTime>
implements IDateTimeConfigEntry {
    private final LocalDateTime minDateTime;
    private final LocalDateTime maxDateTime;

    public DateTimeConfigEntry(String key, LocalDateTime defaultValue) {
        this(key, defaultValue, null, null);
    }

    public DateTimeConfigEntry(String key, LocalDateTime defaultValue, LocalDateTime minDateTime, LocalDateTime maxDateTime) {
        super(key, defaultValue);
        this.minDateTime = minDateTime;
        this.maxDateTime = maxDateTime;
    }

    @Override
    public void validate(LocalDateTime value) throws ConfigEntryValidationException {
        if (this.minDateTime != null && value.isBefore(this.minDateTime) || this.maxDateTime != null && value.isAfter(this.maxDateTime)) {
            String minDateTime = this.minDateTime != null ? this.minDateTime.format(IDateTimeConfigEntry.DATE_TIME_FORMATTER) : null;
            String maxDateTime = this.maxDateTime != null ? this.maxDateTime.format(IDateTimeConfigEntry.DATE_TIME_FORMATTER) : null;
            throw new ConfigEntryValidationException(this.getKey(), "Value is out of bounds. Expected between " + minDateTime + " and " + maxDateTime);
        }
    }

    @Override
    public IConfigEntryType<IConfigEntry<LocalDateTime>, LocalDateTime> getType() {
        return ConfigEntryTypes.DATE_TIME;
    }

    @Override
    public LocalDateTime getMinDateTime() {
        return this.minDateTime;
    }

    @Override
    public LocalDateTime getMaxDateTime() {
        return this.maxDateTime;
    }

    @Override
    public IComments getComments() {
        IComments comments = super.getComments();
        if (comments.showValidationParameters()) {
            if (this.minDateTime != null) {
                comments.addValidationParameter("Minimum value: " + this.minDateTime.format(IDateTimeConfigEntry.DATE_TIME_FORMATTER));
            }
            if (this.maxDateTime != null) {
                comments.addValidationParameter("Maximum value: " + this.maxDateTime.format(IDateTimeConfigEntry.DATE_TIME_FORMATTER));
            }
        }
        if (comments.showDefaultValues()) {
            comments.addDefaultValues("'" + ((LocalDateTime)this.getDefaultValue()).format(IDateTimeConfigEntry.DATE_TIME_FORMATTER) + "'");
        }
        return comments;
    }

    public static class Serializer
    implements IConfigEntrySerializer<IDateTimeConfigEntry, LocalDateTime> {
        @Override
        public void toNode(IDateTimeConfigEntry configEntry, IMapNode parentMap) {
            ConfigValueNode<String> node = new ConfigValueNode<String>(((LocalDateTime)configEntry.get()).format(IDateTimeConfigEntry.DATE_TIME_FORMATTER));
            node.setComments(configEntry.getComments().getComments());
            parentMap.put(configEntry.getKey(), node);
        }

        @Override
        public void fromNode(IDateTimeConfigEntry configEntry, IMapNode parentMap) {
            IValueNode valueNode;
            IConfigNode node = parentMap.get(configEntry.getKey());
            if (node instanceof IValueNode && (valueNode = (IValueNode)node).getValue() != null) {
                try {
                    configEntry.set(LocalDateTime.parse(valueNode.getValue().toString(), IDateTimeConfigEntry.DATE_TIME_FORMATTER));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void valueToNetwork(RegistryFriendlyByteBuf buf, IDateTimeConfigEntry configEntry, LocalDateTime value) {
            buf.writeLong(value.toEpochSecond(ZoneOffset.UTC));
        }

        @Override
        public LocalDateTime valueFromNetwork(RegistryFriendlyByteBuf buf) {
            return LocalDateTime.ofEpochSecond(buf.readLong(), 0, ZoneOffset.UTC);
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf buf, IDateTimeConfigEntry configEntry) {
            buf.writeUtf(configEntry.getKey());
            buf.writeLong(((LocalDateTime)configEntry.get()).toEpochSecond(ZoneOffset.UTC));
            buf.writeLong(((LocalDateTime)configEntry.getDefaultValue()).toEpochSecond(ZoneOffset.UTC));
            buf.writeLong(configEntry.getMinDateTime() != null ? configEntry.getMinDateTime().toEpochSecond(ZoneOffset.UTC) : Long.MIN_VALUE);
            buf.writeLong(configEntry.getMaxDateTime() != null ? configEntry.getMaxDateTime().toEpochSecond(ZoneOffset.UTC) : Long.MAX_VALUE);
            buf.writeCollection(configEntry.getComments().getComments(false), FriendlyByteBuf::writeUtf);
        }

        @Override
        public IDateTimeConfigEntry fromNetwork(RegistryFriendlyByteBuf buf) {
            String key = buf.readUtf();
            LocalDateTime value = LocalDateTime.ofEpochSecond(buf.readLong(), 0, ZoneOffset.UTC);
            LocalDateTime defaultValue = LocalDateTime.ofEpochSecond(buf.readLong(), 0, ZoneOffset.UTC);
            LocalDateTime minDateTime = buf.readLong() != Long.MIN_VALUE ? LocalDateTime.ofEpochSecond(buf.readLong(), 0, ZoneOffset.UTC) : null;
            LocalDateTime maxDateTime = buf.readLong() != Long.MAX_VALUE ? LocalDateTime.ofEpochSecond(buf.readLong(), 0, ZoneOffset.UTC) : null;
            DateTimeConfigEntry configEntry = new DateTimeConfigEntry(key, defaultValue, minDateTime, maxDateTime);
            configEntry.set(value);
            buf.readList(FriendlyByteBuf::readUtf).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

