/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry;

import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.IEnumConfigEntry;
import com.daqem.yamlconfig.api.config.entry.comment.IComments;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.api.exception.ConfigEntryValidationException;
import com.daqem.yamlconfig.api.node.IConfigNode;
import com.daqem.yamlconfig.api.node.IMapNode;
import com.daqem.yamlconfig.api.node.IValueNode;
import com.daqem.yamlconfig.impl.config.entry.BaseConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import com.daqem.yamlconfig.impl.node.ConfigValueNode;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class EnumConfigEntry<E extends Enum<E>>
extends BaseConfigEntry<E>
implements IEnumConfigEntry<E> {
    private final Class<E> enumClass;

    public EnumConfigEntry(String key, E defaultValue, Class<E> enumClass) {
        super(key, defaultValue);
        this.enumClass = enumClass;
    }

    @Override
    public void validate(E value) throws ConfigEntryValidationException {
        if (value == null) {
            throw new ConfigEntryValidationException(this.getKey(), "Value cannot be null");
        }
    }

    @Override
    public IConfigEntryType<IConfigEntry<E>, E> getType() {
        return ConfigEntryTypes.ENUM;
    }

    @Override
    public Class<E> getEnumClass() {
        return this.enumClass;
    }

    @Override
    public IComments getComments() {
        IComments comments = super.getComments();
        if (comments.showValidationParameters()) {
            comments.addValidationParameter("Allowed values: " + String.valueOf(Stream.of((Enum[])this.getEnumClass().getEnumConstants()).map(s -> "'" + String.valueOf(s) + "'").toList()));
        }
        if (comments.showDefaultValues()) {
            comments.addDefaultValues(((Enum)this.getDefaultValue()).toString());
        }
        return comments;
    }

    public static class Serializer<E extends Enum<E>>
    implements IConfigEntrySerializer<IEnumConfigEntry<E>, E> {
        @Override
        public void toNode(IEnumConfigEntry<E> configEntry, IMapNode parentMap) {
            ConfigValueNode<String> node = new ConfigValueNode<String>(((Enum)configEntry.get()).name());
            node.setComments(configEntry.getComments().getComments());
            parentMap.put(configEntry.getKey(), node);
        }

        @Override
        public void fromNode(IEnumConfigEntry<E> configEntry, IMapNode parentMap) {
            IValueNode valueNode;
            IConfigNode node = parentMap.get(configEntry.getKey());
            if (node instanceof IValueNode && (valueNode = (IValueNode)node).getValue() != null) {
                try {
                    configEntry.set(Enum.valueOf(configEntry.getEnumClass(), valueNode.getValue().toString()));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void valueToNetwork(RegistryFriendlyByteBuf buf, IEnumConfigEntry<E> configEntry, E value) {
            buf.writeUtf(configEntry.getEnumClass().getName());
            buf.writeEnum(value);
        }

        @Override
        public E valueFromNetwork(RegistryFriendlyByteBuf buf) {
            try {
                Class<?> enumClass = Class.forName(buf.readUtf());
                return (E)buf.readEnum(enumClass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf buf, IEnumConfigEntry<E> configEntry) {
            buf.writeUtf(configEntry.getKey());
            buf.writeUtf(configEntry.getEnumClass().getName());
            buf.writeUtf(((Enum)configEntry.get()).name());
            buf.writeUtf(((Enum)configEntry.getDefaultValue()).name());
            buf.writeCollection(configEntry.getComments().getComments(false), FriendlyByteBuf::writeUtf);
        }

        @Override
        public IEnumConfigEntry<E> fromNetwork(RegistryFriendlyByteBuf buf) {
            String key = buf.readUtf();
            String enumClassName = buf.readUtf();
            String enumValue = buf.readUtf();
            String defaultEnumValue = buf.readUtf();
            try {
                Class<?> enumClass = Class.forName(enumClassName);
                EnumConfigEntry configEntry = new EnumConfigEntry(key, Enum.valueOf(enumClass, defaultEnumValue), enumClass);
                configEntry.set(Enum.valueOf(enumClass, enumValue));
                buf.readList(FriendlyByteBuf::readUtf).forEach(configEntry.getComments()::addComment);
                return configEntry;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

