/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry;

import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.IStringConfigEntry;
import com.daqem.yamlconfig.api.config.entry.comment.IComments;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.api.exception.ConfigEntryValidationException;
import com.daqem.yamlconfig.api.node.IConfigNode;
import com.daqem.yamlconfig.api.node.IMapNode;
import com.daqem.yamlconfig.api.node.IValueNode;
import com.daqem.yamlconfig.impl.config.entry.BaseConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import com.daqem.yamlconfig.impl.node.ConfigValueNode;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

public class StringConfigEntry
extends BaseConfigEntry<String>
implements IStringConfigEntry {
    private final int minLength;
    private final int maxLength;
    @Nullable
    private final String pattern;
    private final List<String> validValues;

    public StringConfigEntry(String key, String defaultValue) {
        this(key, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public StringConfigEntry(String key, String defaultValue, int minLength, int maxLength) {
        this(key, defaultValue, minLength, maxLength, List.of());
    }

    public StringConfigEntry(String key, String defaultValue, int minLength, int maxLength, @Nullable String pattern) {
        this(key, defaultValue, minLength, maxLength, pattern, List.of());
    }

    public StringConfigEntry(String key, String defaultValue, int minLength, int maxLength, List<String> validValues) {
        this(key, defaultValue, minLength, maxLength, null, validValues);
    }

    public StringConfigEntry(String key, String defaultValue, int minLength, int maxLength, @Nullable String pattern, List<String> validValues) {
        super(key, defaultValue);
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.pattern = pattern;
        this.validValues = validValues;
    }

    @Override
    public void validate(String value) throws ConfigEntryValidationException {
        if (this.minLength != Integer.MIN_VALUE && value.length() < this.minLength) {
            throw new ConfigEntryValidationException(this.getKey(), "String length (" + value.length() + ") is less than the minimum length (" + this.minLength + ")");
        }
        if (this.maxLength != Integer.MAX_VALUE && value.length() > this.maxLength) {
            throw new ConfigEntryValidationException(this.getKey(), "String length (" + value.length() + ") is greater than the maximum length (" + this.maxLength + ")");
        }
        if (this.pattern != null && !value.matches(this.pattern)) {
            throw new ConfigEntryValidationException(this.getKey(), "String (" + value + ") does not match the pattern (" + this.pattern + ")");
        }
        if (!this.validValues.isEmpty() && !this.validValues.contains(value)) {
            throw new ConfigEntryValidationException(this.getKey(), "String (" + value + ") is not a valid value");
        }
    }

    @Override
    public int getMinLength() {
        return this.minLength;
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    @Nullable
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public List<String> getValidValues() {
        return this.validValues;
    }

    @Override
    public IComments getComments() {
        IComments comments = super.getComments();
        if (comments.showValidationParameters()) {
            if (this.minLength != Integer.MIN_VALUE) {
                comments.addValidationParameter("Minimum length: " + this.minLength);
            }
            if (this.maxLength != Integer.MAX_VALUE) {
                comments.addValidationParameter("Maximum length: " + this.maxLength);
            }
            if (this.pattern != null) {
                comments.addValidationParameter("Pattern: " + this.pattern);
            }
            if (!this.validValues.isEmpty()) {
                comments.addValidationParameter("Valid values: " + String.valueOf(this.validValues));
            }
        }
        if (comments.showDefaultValues()) {
            comments.addDefaultValues("'" + (String)this.getDefaultValue() + "'");
        }
        return comments;
    }

    @Override
    public IConfigEntryType<IConfigEntry<String>, String> getType() {
        return ConfigEntryTypes.STRING;
    }

    public static class Serializer
    implements IConfigEntrySerializer<IStringConfigEntry, String> {
        @Override
        public void toNode(IStringConfigEntry configEntry, IMapNode parentMap) {
            ConfigValueNode<String> node = new ConfigValueNode<String>((String)configEntry.get());
            node.setComments(configEntry.getComments().getComments());
            parentMap.put(configEntry.getKey(), node);
        }

        @Override
        public void fromNode(IStringConfigEntry configEntry, IMapNode parentMap) {
            IValueNode valueNode;
            IConfigNode node = parentMap.get(configEntry.getKey());
            if (node instanceof IValueNode && (valueNode = (IValueNode)node).getValue() != null) {
                configEntry.set(valueNode.getValue().toString());
            }
        }

        @Override
        public void valueToNetwork(RegistryFriendlyByteBuf buf, IStringConfigEntry configEntry, String value) {
            buf.writeUtf(value);
        }

        @Override
        public String valueFromNetwork(RegistryFriendlyByteBuf buf) {
            return buf.readUtf();
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf buf, IStringConfigEntry configEntry) {
            buf.writeUtf(configEntry.getKey());
            buf.writeUtf((String)configEntry.getDefaultValue());
            buf.writeInt(configEntry.getMinLength());
            buf.writeInt(configEntry.getMaxLength());
            buf.writeUtf((String)configEntry.get());
            buf.writeCollection(configEntry.getComments().getComments(false), FriendlyByteBuf::writeUtf);
        }

        @Override
        public IStringConfigEntry fromNetwork(RegistryFriendlyByteBuf buf) {
            StringConfigEntry configEntry = new StringConfigEntry(buf.readUtf(), buf.readUtf(), buf.readInt(), buf.readInt());
            configEntry.set(buf.readUtf());
            buf.readList(FriendlyByteBuf::readUtf).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

