/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry.list;

import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.comment.IComments;
import com.daqem.yamlconfig.api.config.entry.list.IStringListConfigEntry;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.api.exception.ConfigEntryValidationException;
import com.daqem.yamlconfig.api.node.IConfigNode;
import com.daqem.yamlconfig.api.node.IListNode;
import com.daqem.yamlconfig.api.node.IMapNode;
import com.daqem.yamlconfig.api.node.IValueNode;
import com.daqem.yamlconfig.impl.config.entry.list.BaseListConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import com.daqem.yamlconfig.impl.node.ConfigListNode;
import com.daqem.yamlconfig.impl.node.ConfigValueNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

public class StringListConfigEntry
extends BaseListConfigEntry<String>
implements IStringListConfigEntry {
    @Nullable
    private final String pattern;
    private final List<String> validValues;

    public StringListConfigEntry(String key, List<String> defaultValue) {
        this(key, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public StringListConfigEntry(String key, List<String> defaultValue, int minLength, int maxLength) {
        this(key, defaultValue, minLength, maxLength, List.of());
    }

    public StringListConfigEntry(String key, List<String> defaultValue, @Nullable String pattern) {
        this(key, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE, pattern, List.of());
    }

    public StringListConfigEntry(String key, List<String> defaultValue, List<String> validValues) {
        this(key, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE, null, validValues);
    }

    public StringListConfigEntry(String key, List<String> defaultValue, @Nullable String pattern, List<String> validValues) {
        this(key, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE, pattern, validValues);
    }

    public StringListConfigEntry(String key, List<String> defaultValue, int minLength, int maxLength, @Nullable String pattern) {
        this(key, defaultValue, minLength, maxLength, pattern, List.of());
    }

    public StringListConfigEntry(String key, List<String> defaultValue, int minLength, int maxLength, List<String> validValues) {
        this(key, defaultValue, minLength, maxLength, null, validValues);
    }

    public StringListConfigEntry(String key, List<String> defaultValue, int minLength, int maxLength, @Nullable String pattern, List<String> validValues) {
        super(key, defaultValue, minLength, maxLength);
        this.pattern = pattern;
        this.validValues = validValues;
    }

    @Override
    public void validate(List<String> value) throws ConfigEntryValidationException {
        super.validate(value);
        for (String element : value) {
            if (this.pattern != null && !element.matches(this.pattern)) {
                throw new ConfigEntryValidationException(this.getKey(), "Element (" + element + ") does not match the pattern (" + this.pattern + ")");
            }
            if (this.validValues.isEmpty() || this.validValues.contains(element)) continue;
            throw new ConfigEntryValidationException(this.getKey(), "Element (" + element + ") is not a valid value");
        }
    }

    @Override
    public IConfigEntryType<IConfigEntry<List<String>>, List<String>> getType() {
        return ConfigEntryTypes.STRING_LIST;
    }

    @Override
    @Nullable
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public List<String> getValidValues() {
        return this.validValues;
    }

    @Override
    public IComments getComments() {
        IComments comments = super.getComments();
        if (comments.showValidationParameters()) {
            if (this.pattern != null) {
                comments.addValidationParameter("Pattern: " + this.pattern);
            }
            if (!this.validValues.isEmpty()) {
                comments.addValidationParameter("Valid values: " + String.valueOf(this.validValues));
            }
        }
        if (comments.showDefaultValues()) {
            comments.addDefaultValues(((List)this.getDefaultValue()).stream().map(s -> "'" + s + "'").toList().toString());
        }
        return comments;
    }

    public static class Serializer
    implements IConfigEntrySerializer<IStringListConfigEntry, List<String>> {
        @Override
        public void toNode(IStringListConfigEntry configEntry, IMapNode parentMap) {
            ConfigListNode listNode = new ConfigListNode();
            for (String s : (List)configEntry.get()) {
                listNode.add(new ConfigValueNode<String>(s));
            }
            listNode.setComments(configEntry.getComments().getComments());
            parentMap.put(configEntry.getKey(), listNode);
        }

        @Override
        public void fromNode(IStringListConfigEntry configEntry, IMapNode parentMap) {
            IConfigNode node = parentMap.get(configEntry.getKey());
            if (node instanceof IListNode) {
                IListNode listNode = (IListNode)node;
                ArrayList<String> list = new ArrayList<String>();
                Iterator iterator = listNode.getValue().iterator();
                while (iterator.hasNext()) {
                    IValueNode valueNode;
                    IConfigNode child = (IConfigNode)iterator.next();
                    if (!(child instanceof IValueNode) || (valueNode = (IValueNode)child).getValue() == null) continue;
                    list.add(valueNode.getValue().toString());
                }
                configEntry.set(list);
            }
        }

        @Override
        public void valueToNetwork(RegistryFriendlyByteBuf buf, IStringListConfigEntry configEntry, List<String> value) {
            buf.writeCollection(value, FriendlyByteBuf::writeUtf);
        }

        @Override
        public List<String> valueFromNetwork(RegistryFriendlyByteBuf buf) {
            return buf.readList(FriendlyByteBuf::readUtf);
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf buf, IStringListConfigEntry configEntry) {
            buf.writeUtf(configEntry.getKey());
            buf.writeCollection((Collection)configEntry.get(), FriendlyByteBuf::writeUtf);
            buf.writeCollection((Collection)configEntry.getDefaultValue(), FriendlyByteBuf::writeUtf);
            buf.writeInt(configEntry.getMinLength());
            buf.writeInt(configEntry.getMaxLength());
            buf.writeUtf(configEntry.getPattern() == null ? "" : configEntry.getPattern());
            buf.writeCollection(configEntry.getValidValues(), FriendlyByteBuf::writeUtf);
            buf.writeCollection(configEntry.getComments().getComments(false), FriendlyByteBuf::writeUtf);
        }

        @Override
        public IStringListConfigEntry fromNetwork(RegistryFriendlyByteBuf buf) {
            String key = buf.readUtf();
            List value = buf.readList(FriendlyByteBuf::readUtf);
            List defaultValue = buf.readList(FriendlyByteBuf::readUtf);
            int minLength = buf.readInt();
            int maxLength = buf.readInt();
            String pattern = buf.readUtf();
            List validValues = buf.readList(FriendlyByteBuf::readUtf);
            StringListConfigEntry configEntry = new StringListConfigEntry(key, defaultValue, minLength, maxLength, pattern.isEmpty() ? null : pattern, validValues);
            configEntry.set(value);
            buf.readList(FriendlyByteBuf::readUtf).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

