/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry.minecraft;

import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.comment.IComments;
import com.daqem.yamlconfig.api.config.entry.minecraft.IRegistryConfigEntry;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.api.exception.ConfigEntryValidationException;
import com.daqem.yamlconfig.api.node.IConfigNode;
import com.daqem.yamlconfig.api.node.IMapNode;
import com.daqem.yamlconfig.api.node.IValueNode;
import com.daqem.yamlconfig.impl.config.entry.BaseConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import com.daqem.yamlconfig.impl.node.ConfigValueNode;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;

public class RegistryConfigEntry<T>
extends BaseConfigEntry<T>
implements IRegistryConfigEntry<T> {
    private final Registry<T> registry;

    public RegistryConfigEntry(String key, T defaultValue, Registry<T> registry) {
        super(key, defaultValue);
        this.registry = registry;
    }

    @Override
    public void validate(T value) throws ConfigEntryValidationException {
        if (this.registry.getKey(value) == null) {
            throw new ConfigEntryValidationException(this.getKey(), "Value is not in registry.");
        }
    }

    @Override
    public IConfigEntryType<IConfigEntry<T>, T> getType() {
        return ConfigEntryTypes.REGISTRY;
    }

    @Override
    public Registry<T> getRegistry() {
        return this.registry;
    }

    @Override
    public IComments getComments() {
        IComments comments = super.getComments();
        if (comments.showValidationParameters()) {
            comments.addValidationParameter("Registry: " + String.valueOf(this.getRegistry().key().identifier()));
        }
        if (comments.showDefaultValues()) {
            comments.addDefaultValues("'" + String.valueOf(this.getRegistry().getKey(this.getDefaultValue())) + "'");
        }
        return comments;
    }

    public static class Serializer<T>
    implements IConfigEntrySerializer<IRegistryConfigEntry<T>, T> {
        @Override
        public void toNode(IRegistryConfigEntry<T> configEntry, IMapNode parentMap) {
            Identifier key = configEntry.getRegistry().getKey(configEntry.get());
            if (key != null) {
                ConfigValueNode<String> node = new ConfigValueNode<String>(key.toString());
                node.setComments(configEntry.getComments().getComments());
                parentMap.put(configEntry.getKey(), node);
            }
        }

        @Override
        public void fromNode(IRegistryConfigEntry<T> configEntry, IMapNode parentMap) {
            Identifier rl;
            IValueNode valueNode;
            IConfigNode node = parentMap.get(configEntry.getKey());
            if (node instanceof IValueNode && (valueNode = (IValueNode)node).getValue() != null && (rl = Identifier.tryParse((String)valueNode.getValue().toString())) != null) {
                configEntry.getRegistry().get(rl).ifPresent(ref -> configEntry.set(ref.value()));
            }
        }

        @Override
        public void valueToNetwork(RegistryFriendlyByteBuf buf, IRegistryConfigEntry<T> configEntry, T value) {
            buf.writeResourceKey(configEntry.getRegistry().key());
            Identifier resourceLocation = configEntry.getRegistry().getKey(value);
            buf.writeIdentifier(Objects.requireNonNull(resourceLocation));
        }

        @Override
        public T valueFromNetwork(RegistryFriendlyByteBuf buf) {
            ResourceKey key = buf.readRegistryKey();
            Identifier resourceLocation = buf.readIdentifier();
            Optional reference = BuiltInRegistries.REGISTRY.get(key);
            return reference.map(registry -> ((Holder.Reference)((Registry)registry.value()).get(resourceLocation).get()).value()).orElse(null);
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf buf, IRegistryConfigEntry<T> configEntry) {
            buf.writeUtf(configEntry.getKey());
            buf.writeResourceKey(configEntry.getRegistry().key());
            buf.writeIdentifier(Objects.requireNonNull(configEntry.getRegistry().getKey(configEntry.get())));
            buf.writeIdentifier(Objects.requireNonNull(configEntry.getRegistry().getKey(configEntry.getDefaultValue())));
            buf.writeCollection(configEntry.getComments().getComments(false), FriendlyByteBuf::writeUtf);
        }

        @Override
        public IRegistryConfigEntry<T> fromNetwork(RegistryFriendlyByteBuf buf) {
            String key = buf.readUtf();
            ResourceKey registryKey = buf.readRegistryKey();
            Identifier resourceLocation = buf.readIdentifier();
            Identifier defaultIdentifier = buf.readIdentifier();
            Optional reference = BuiltInRegistries.REGISTRY.get(registryKey);
            RegistryConfigEntry<Object> configEntry = new RegistryConfigEntry<Object>(key, reference.map(registry -> ((Holder.Reference)((Registry)registry.value()).get(defaultIdentifier).get()).value()).orElse(null), reference.map(Holder.Reference::value).orElse(null));
            configEntry.set(reference.map(registry -> ((Holder.Reference)((Registry)registry.value()).get(resourceLocation).get()).value()).orElse(null));
            buf.readList(FriendlyByteBuf::readUtf).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

