/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry.numeric;

import com.daqem.yamlconfig.api.config.entry.comment.IComments;
import com.daqem.yamlconfig.api.config.entry.numeric.INumericConfigEntry;
import com.daqem.yamlconfig.api.exception.ConfigEntryValidationException;
import com.daqem.yamlconfig.impl.config.entry.BaseConfigEntry;
import org.jetbrains.annotations.NotNull;

public abstract class BaseNumericConfigEntry<T extends Number>
extends BaseConfigEntry<T>
implements INumericConfigEntry<T> {
    private final T minValue;
    private final T maxValue;

    public BaseNumericConfigEntry(String key, @NotNull T defaultValue, @NotNull T minValue, @NotNull T maxValue) {
        super(key, defaultValue);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public void validate(T value) throws ConfigEntryValidationException {
        if (this.minValue != null && ((Comparable)value).compareTo(this.minValue) < 0 || this.maxValue != null && ((Comparable)value).compareTo(this.maxValue) > 0) {
            throw new ConfigEntryValidationException(this.getKey(), "Value is out of bounds. Expected between " + String.valueOf(this.minValue) + " and " + String.valueOf(this.maxValue));
        }
    }

    @Override
    public T getMinValue() {
        return this.minValue;
    }

    @Override
    public T getMaxValue() {
        return this.maxValue;
    }

    @Override
    public IComments getComments() {
        IComments comments = super.getComments();
        if (comments.showValidationParameters()) {
            if (this.minValue != null) {
                comments.addValidationParameter("Minimum value: " + String.valueOf(this.minValue));
            }
            if (this.maxValue != null) {
                comments.addValidationParameter("Maximum value: " + String.valueOf(this.maxValue));
            }
        }
        if (comments.showDefaultValues()) {
            comments.addDefaultValues(((Number)this.getDefaultValue()).toString());
        }
        return comments;
    }
}

