/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry.numeric;

import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.numeric.IFloatConfigEntry;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.api.node.IConfigNode;
import com.daqem.yamlconfig.api.node.IMapNode;
import com.daqem.yamlconfig.api.node.IValueNode;
import com.daqem.yamlconfig.impl.config.entry.numeric.BaseNumericConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import com.daqem.yamlconfig.impl.node.ConfigValueNode;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class FloatConfigEntry
extends BaseNumericConfigEntry<Float>
implements IFloatConfigEntry {
    public FloatConfigEntry(String key, Float defaultValue) {
        super(key, defaultValue, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
    }

    public FloatConfigEntry(String key, Float defaultValue, Float minValue, Float maxValue) {
        super(key, defaultValue, minValue, maxValue);
    }

    @Override
    public IConfigEntryType<IConfigEntry<Float>, Float> getType() {
        return ConfigEntryTypes.FLOAT;
    }

    public static class Serializer
    implements IConfigEntrySerializer<IFloatConfigEntry, Float> {
        @Override
        public void toNode(IFloatConfigEntry configEntry, IMapNode parentMap) {
            ConfigValueNode<Float> node = new ConfigValueNode<Float>((Float)configEntry.get());
            node.setComments(configEntry.getComments().getComments());
            parentMap.put(configEntry.getKey(), node);
        }

        @Override
        public void fromNode(IFloatConfigEntry configEntry, IMapNode parentMap) {
            IConfigNode node = parentMap.get(configEntry.getKey());
            if (node instanceof IValueNode) {
                IValueNode valueNode = (IValueNode)node;
                Object val = valueNode.getValue();
                if (val instanceof Number) {
                    Number number = (Number)val;
                    configEntry.set(Float.valueOf(number.floatValue()));
                } else if (val instanceof String) {
                    try {
                        configEntry.set(Float.valueOf(Float.parseFloat((String)val)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public void valueToNetwork(RegistryFriendlyByteBuf buf, IFloatConfigEntry configEntry, Float value) {
            buf.writeFloat(value.floatValue());
        }

        @Override
        public Float valueFromNetwork(RegistryFriendlyByteBuf buf) {
            return Float.valueOf(buf.readFloat());
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf buf, IFloatConfigEntry configEntry) {
            buf.writeUtf(configEntry.getKey());
            buf.writeFloat(((Float)configEntry.getDefaultValue()).floatValue());
            buf.writeFloat(((Float)configEntry.getMinValue()).floatValue());
            buf.writeFloat(((Float)configEntry.getMaxValue()).floatValue());
            buf.writeFloat(((Float)configEntry.get()).floatValue());
            buf.writeCollection(configEntry.getComments().getComments(false), FriendlyByteBuf::writeUtf);
        }

        @Override
        public IFloatConfigEntry fromNetwork(RegistryFriendlyByteBuf buf) {
            FloatConfigEntry configEntry = new FloatConfigEntry(buf.readUtf(), Float.valueOf(buf.readFloat()), Float.valueOf(buf.readFloat()), Float.valueOf(buf.readFloat()));
            configEntry.set(Float.valueOf(buf.readFloat()));
            buf.readList(FriendlyByteBuf::readUtf).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

