/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.format.hocon;

import com.daqem.yamlconfig.api.config.ConfigExtension;
import com.daqem.yamlconfig.api.format.IConfigFormat;
import com.daqem.yamlconfig.api.node.IConfigNode;
import com.daqem.yamlconfig.api.node.IListNode;
import com.daqem.yamlconfig.api.node.IMapNode;
import com.daqem.yamlconfig.api.node.IValueNode;
import com.daqem.yamlconfig.impl.node.ConfigListNode;
import com.daqem.yamlconfig.impl.node.ConfigMapNode;
import com.daqem.yamlconfig.impl.node.ConfigValueNode;
import com.daqem.yamlconfig.libs.configurate.CommentedConfigurationNode;
import com.daqem.yamlconfig.libs.configurate.ConfigurateException;
import com.daqem.yamlconfig.libs.configurate.ConfigurationNode;
import com.daqem.yamlconfig.libs.configurate.hocon.HoconConfigurationLoader;
import com.daqem.yamlconfig.libs.configurate.loader.HeaderMode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public class HoconFormat
implements IConfigFormat {
    @Override
    public IMapNode read(Reader reader) throws IOException {
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().source(() -> bufferedReader)).build();
        try {
            CommentedConfigurationNode root = (CommentedConfigurationNode)loader.load();
            return (IMapNode)this.convertToGeneric(root);
        }
        catch (ConfigurateException e) {
            throw new IOException("Failed to load HOCON", e);
        }
    }

    @Override
    public void write(Writer writer, IMapNode rootNode) throws IOException {
        BufferedWriter bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().sink(() -> bufferedWriter)).headerMode(HeaderMode.PRESERVE)).build();
        try {
            CommentedConfigurationNode root = (CommentedConfigurationNode)loader.createNode();
            this.convertFromGeneric(root, rootNode);
            loader.save(root);
        }
        catch (ConfigurateException e) {
            throw new IOException("Failed to save HOCON", e);
        }
    }

    @Override
    public String getExtension() {
        return ConfigExtension.HOCON.getExtension();
    }

    private IConfigNode convertToGeneric(ConfigurationNode hoconNode) {
        if (hoconNode.isMap()) {
            ConfigMapNode mapNode = new ConfigMapNode();
            for (Map.Entry<Object, ? extends ConfigurationNode> entry : hoconNode.childrenMap().entrySet()) {
                IConfigNode child = this.convertToGeneric(entry.getValue());
                mapNode.put(entry.getKey().toString(), child);
            }
            this.extractComment(hoconNode, mapNode);
            return mapNode;
        }
        if (hoconNode.isList()) {
            ConfigListNode listNode = new ConfigListNode();
            for (ConfigurationNode configurationNode : hoconNode.childrenList()) {
                listNode.add(this.convertToGeneric(configurationNode));
            }
            this.extractComment(hoconNode, listNode);
            return listNode;
        }
        ConfigValueNode<Object> valueNode = new ConfigValueNode<Object>(hoconNode.raw());
        this.extractComment(hoconNode, valueNode);
        return valueNode;
    }

    private void extractComment(ConfigurationNode hoconNode, IConfigNode myNode) {
        CommentedConfigurationNode commented;
        String comment;
        if (hoconNode instanceof CommentedConfigurationNode && (comment = (commented = (CommentedConfigurationNode)hoconNode).comment()) != null) {
            myNode.setComments(Arrays.asList(comment.split("\n")));
        }
    }

    private void convertFromGeneric(CommentedConfigurationNode hoconNode, IConfigNode myNode) {
        if (myNode.getComments() != null && !myNode.getComments().isEmpty()) {
            hoconNode.comment(String.join((CharSequence)"\n", myNode.getComments()));
        }
        if (myNode instanceof IMapNode) {
            IMapNode mapNode = (IMapNode)myNode;
            for (Map.Entry<String, IConfigNode> entry : mapNode.entrySet()) {
                this.convertFromGeneric((CommentedConfigurationNode)hoconNode.node(new Object[]{entry.getKey()}), entry.getValue());
            }
        } else if (myNode instanceof IListNode) {
            IListNode listNode = (IListNode)myNode;
            Iterator iterator = listNode.getValue().iterator();
            while (iterator.hasNext()) {
                IConfigNode child = (IConfigNode)iterator.next();
                this.convertFromGeneric((CommentedConfigurationNode)hoconNode.appendListNode(), child);
            }
        } else if (myNode instanceof IValueNode) {
            IValueNode valueNode = (IValueNode)myNode;
            try {
                hoconNode.set(valueNode.getValue());
            }
            catch (ConfigurateException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

