/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.format.json5;

import com.daqem.yamlconfig.api.config.ConfigExtension;
import com.daqem.yamlconfig.api.format.IConfigFormat;
import com.daqem.yamlconfig.api.node.IConfigNode;
import com.daqem.yamlconfig.api.node.IListNode;
import com.daqem.yamlconfig.api.node.IMapNode;
import com.daqem.yamlconfig.api.node.IValueNode;
import com.daqem.yamlconfig.impl.node.ConfigListNode;
import com.daqem.yamlconfig.impl.node.ConfigMapNode;
import com.daqem.yamlconfig.impl.node.ConfigValueNode;
import com.daqem.yamlconfig.libs.jankson.Jankson;
import com.daqem.yamlconfig.libs.jankson.JsonArray;
import com.daqem.yamlconfig.libs.jankson.JsonElement;
import com.daqem.yamlconfig.libs.jankson.JsonNull;
import com.daqem.yamlconfig.libs.jankson.JsonObject;
import com.daqem.yamlconfig.libs.jankson.JsonPrimitive;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public class Json5Format
implements IConfigFormat {
    private final Jankson jankson = Jankson.builder().build();

    @Override
    public IMapNode read(Reader reader) throws IOException {
        try {
            JsonObject jsonObject = this.jankson.load(CharStreams.toString((Readable)reader));
            return (IMapNode)this.convertToGeneric(jsonObject);
        }
        catch (Exception e) {
            throw new IOException("Failed to parse JSON5", e);
        }
    }

    @Override
    public void write(Writer writer, IMapNode rootNode) throws IOException {
        JsonElement jsonElement = this.convertFromGeneric(rootNode);
        writer.write(jsonElement.toJson(true, true));
    }

    @Override
    public String getExtension() {
        return ConfigExtension.JSON5.getExtension();
    }

    private IConfigNode convertToGeneric(JsonElement element) {
        if (element instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)element;
            ConfigMapNode mapNode = new ConfigMapNode();
            for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
                IConfigNode child = this.convertToGeneric(entry.getValue());
                String comment = jsonObject.getComment(entry.getKey());
                if (comment != null) {
                    child.setComments(Arrays.asList(comment.split("\n")));
                }
                mapNode.put(entry.getKey(), child);
            }
            return mapNode;
        }
        if (element instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)element;
            ConfigListNode listNode = new ConfigListNode();
            for (JsonElement child : jsonArray) {
                listNode.add(this.convertToGeneric(child));
            }
            return listNode;
        }
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            return new ConfigValueNode<Object>(primitive.getValue());
        }
        if (element instanceof JsonNull) {
            return new ConfigValueNode<Object>(null);
        }
        throw new IllegalArgumentException("Unknown JSON Element: " + String.valueOf(element.getClass()));
    }

    private JsonElement convertFromGeneric(IConfigNode node) {
        if (node instanceof IMapNode) {
            IMapNode mapNode = (IMapNode)node;
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry<String, IConfigNode> entry : mapNode.entrySet()) {
                JsonElement child = this.convertFromGeneric(entry.getValue());
                jsonObject.put(entry.getKey(), child);
                if (entry.getValue().getComments() == null || entry.getValue().getComments().isEmpty()) continue;
                jsonObject.setComment(entry.getKey(), String.join((CharSequence)"\n", entry.getValue().getComments()));
            }
            return jsonObject;
        }
        if (node instanceof IListNode) {
            IListNode listNode = (IListNode)node;
            JsonArray jsonArray = new JsonArray();
            Iterator iterator = listNode.getValue().iterator();
            while (iterator.hasNext()) {
                IConfigNode child = (IConfigNode)iterator.next();
                jsonArray.add(this.convertFromGeneric(child));
            }
            return jsonArray;
        }
        if (node instanceof IValueNode) {
            IValueNode valueNode = (IValueNode)node;
            Object val = valueNode.getValue();
            if (val == null) {
                return JsonNull.INSTANCE;
            }
            return new JsonPrimitive(val);
        }
        return JsonNull.INSTANCE;
    }
}

