/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.format.toml;

import com.daqem.yamlconfig.api.config.ConfigExtension;
import com.daqem.yamlconfig.api.format.IConfigFormat;
import com.daqem.yamlconfig.api.node.IConfigNode;
import com.daqem.yamlconfig.api.node.IListNode;
import com.daqem.yamlconfig.api.node.IMapNode;
import com.daqem.yamlconfig.api.node.IValueNode;
import com.daqem.yamlconfig.impl.node.BaseConfigNode;
import com.daqem.yamlconfig.impl.node.ConfigListNode;
import com.daqem.yamlconfig.impl.node.ConfigMapNode;
import com.daqem.yamlconfig.impl.node.ConfigValueNode;
import com.daqem.yamlconfig.libs.nightconfig.core.CommentedConfig;
import com.daqem.yamlconfig.libs.nightconfig.core.Config;
import com.daqem.yamlconfig.libs.nightconfig.core.UnmodifiableConfig;
import com.daqem.yamlconfig.libs.nightconfig.toml.TomlParser;
import com.daqem.yamlconfig.libs.nightconfig.toml.TomlWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TomlFormat
implements IConfigFormat {
    @Override
    public IMapNode read(Reader reader) {
        CommentedConfig tomlConfig = new TomlParser().parse(reader);
        return this.convertToGeneric(tomlConfig);
    }

    @Override
    public void write(Writer writer, IMapNode rootNode) {
        CommentedConfig tomlConfig = this.convertFromGeneric(rootNode);
        new TomlWriter().write((UnmodifiableConfig)tomlConfig, writer);
    }

    @Override
    public String getExtension() {
        return ConfigExtension.TOML.getExtension();
    }

    private ConfigMapNode convertToGeneric(Config config) {
        ConfigMapNode mapNode = new ConfigMapNode();
        for (Config.Entry entry : config.entrySet()) {
            CommentedConfig commentedConfig;
            String comment;
            String key = entry.getKey();
            Object value = entry.getValue();
            BaseConfigNode node = value instanceof Config ? this.convertToGeneric((Config)value) : (value instanceof List ? this.convertListToGeneric((List)value) : new ConfigValueNode(value));
            if (config instanceof CommentedConfig && (comment = (commentedConfig = (CommentedConfig)config).getComment(key)) != null) {
                node.setComments(Arrays.asList(comment.split("\n")));
            }
            mapNode.put(key, node);
        }
        return mapNode;
    }

    private ConfigListNode convertListToGeneric(List<?> list) {
        ConfigListNode listNode = new ConfigListNode();
        for (Object obj : list) {
            if (obj instanceof Config) {
                listNode.add(this.convertToGeneric((Config)obj));
                continue;
            }
            if (obj instanceof List) {
                listNode.add(this.convertListToGeneric((List)obj));
                continue;
            }
            listNode.add(new ConfigValueNode(obj));
        }
        return listNode;
    }

    private CommentedConfig convertFromGeneric(IMapNode node) {
        CommentedConfig config = CommentedConfig.inMemory();
        for (Map.Entry<String, IConfigNode> entry : node.entrySet()) {
            String key = entry.getKey();
            IConfigNode child = entry.getValue();
            Object value = this.resolveValue(child);
            config.set(key, value);
            if (child.getComments() == null || child.getComments().isEmpty()) continue;
            config.setComment(key, String.join((CharSequence)"\n", child.getComments()));
        }
        return config;
    }

    private Object resolveValue(IConfigNode node) {
        if (node instanceof IMapNode) {
            IMapNode mapNode = (IMapNode)node;
            return this.convertFromGeneric(mapNode);
        }
        if (node instanceof IListNode) {
            IListNode listNode = (IListNode)node;
            ArrayList<Object> rawList = new ArrayList<Object>();
            Iterator iterator = listNode.getValue().iterator();
            while (iterator.hasNext()) {
                IConfigNode item = (IConfigNode)iterator.next();
                rawList.add(this.resolveValue(item));
            }
            return rawList;
        }
        if (node instanceof IValueNode) {
            IValueNode valueNode = (IValueNode)node;
            return valueNode.getValue();
        }
        return null;
    }
}

