/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.format.yaml;

import com.daqem.yamlconfig.api.config.ConfigExtension;
import com.daqem.yamlconfig.api.format.IConfigFormat;
import com.daqem.yamlconfig.api.node.IMapNode;
import com.daqem.yamlconfig.impl.format.yaml.YamlNodeConverter;
import com.daqem.yamlconfig.impl.format.yaml.YamlWriterWrapper;
import com.daqem.yamlconfig.libs.snakeyaml.engine.v2.api.Dump;
import com.daqem.yamlconfig.libs.snakeyaml.engine.v2.api.DumpSettings;
import com.daqem.yamlconfig.libs.snakeyaml.engine.v2.api.LoadSettings;
import com.daqem.yamlconfig.libs.snakeyaml.engine.v2.api.lowlevel.Compose;
import com.daqem.yamlconfig.libs.snakeyaml.engine.v2.nodes.Node;
import java.io.Reader;
import java.io.Writer;

public class YamlFormat
implements IConfigFormat {
    private final LoadSettings loadSettings = LoadSettings.builder().setParseComments(true).build();
    private final DumpSettings dumpSettings = DumpSettings.builder().setDumpComments(true).build();

    @Override
    public IMapNode read(Reader reader) {
        Compose compose = new Compose(this.loadSettings);
        Node root = compose.composeReader(reader).orElse(null);
        return YamlNodeConverter.toGeneric(root);
    }

    @Override
    public void write(Writer writer, IMapNode rootNode) {
        Node snakeRoot = YamlNodeConverter.fromGeneric(rootNode);
        YamlWriterWrapper streamWriter = new YamlWriterWrapper(writer);
        new Dump(this.dumpSettings).dumpNode(snakeRoot, streamWriter);
    }

    @Override
    public String getExtension() {
        return ConfigExtension.YAML.getExtension();
    }
}

