/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.format.yaml;

import com.daqem.yamlconfig.api.node.IConfigNode;
import com.daqem.yamlconfig.api.node.IListNode;
import com.daqem.yamlconfig.api.node.IMapNode;
import com.daqem.yamlconfig.api.node.IValueNode;
import com.daqem.yamlconfig.impl.node.BaseConfigNode;
import com.daqem.yamlconfig.impl.node.ConfigListNode;
import com.daqem.yamlconfig.impl.node.ConfigMapNode;
import com.daqem.yamlconfig.impl.node.ConfigValueNode;
import com.daqem.yamlconfig.libs.snakeyaml.engine.v2.comments.CommentLine;
import com.daqem.yamlconfig.libs.snakeyaml.engine.v2.comments.CommentType;
import com.daqem.yamlconfig.libs.snakeyaml.engine.v2.common.FlowStyle;
import com.daqem.yamlconfig.libs.snakeyaml.engine.v2.common.ScalarStyle;
import com.daqem.yamlconfig.libs.snakeyaml.engine.v2.nodes.MappingNode;
import com.daqem.yamlconfig.libs.snakeyaml.engine.v2.nodes.Node;
import com.daqem.yamlconfig.libs.snakeyaml.engine.v2.nodes.NodeTuple;
import com.daqem.yamlconfig.libs.snakeyaml.engine.v2.nodes.ScalarNode;
import com.daqem.yamlconfig.libs.snakeyaml.engine.v2.nodes.SequenceNode;
import com.daqem.yamlconfig.libs.snakeyaml.engine.v2.nodes.Tag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

public class YamlNodeConverter {
    public static IMapNode toGeneric(Node root) {
        if (root instanceof MappingNode) {
            MappingNode mappingNode = (MappingNode)root;
            return (IMapNode)YamlNodeConverter.convertNodeToGeneric(mappingNode);
        }
        return new ConfigMapNode();
    }

    private static IConfigNode convertNodeToGeneric(Node node) {
        BaseConfigNode result;
        if (node instanceof ScalarNode) {
            ScalarNode scalar = (ScalarNode)node;
            result = new ConfigValueNode<Object>(YamlNodeConverter.parseScalar(scalar.getValue()));
        } else if (node instanceof SequenceNode) {
            SequenceNode sequence = (SequenceNode)node;
            ConfigListNode listNode = new ConfigListNode();
            for (Node child : sequence.getValue()) {
                listNode.add(YamlNodeConverter.convertNodeToGeneric(child));
            }
            result = listNode;
        } else if (node instanceof MappingNode) {
            MappingNode mapping = (MappingNode)node;
            ConfigMapNode mapNode = new ConfigMapNode();
            for (NodeTuple tuple : mapping.getValue()) {
                Node node2 = tuple.getKeyNode();
                if (!(node2 instanceof ScalarNode)) continue;
                ScalarNode keyNode = (ScalarNode)node2;
                mapNode.put(keyNode.getValue(), YamlNodeConverter.convertNodeToGeneric(tuple.getValueNode()));
            }
            result = mapNode;
        } else {
            result = new ConfigValueNode<Object>(null);
        }
        if (node.getBlockComments() != null && !node.getBlockComments().isEmpty()) {
            ArrayList<String> comments = new ArrayList<String>();
            for (CommentLine line : node.getBlockComments()) {
                comments.add(line.getValue());
            }
            result.setComments(comments);
        }
        return result;
    }

    private static Object parseScalar(String value) {
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException2) {
                return value;
            }
        }
    }

    public static Node fromGeneric(IMapNode root) {
        return YamlNodeConverter.convertGenericToNode(root);
    }

    /*
     * WARNING - void declaration
     */
    private static Node convertGenericToNode(IConfigNode node) {
        Node result;
        if (node instanceof IValueNode) {
            void var7_8;
            IValueNode valueNode = (IValueNode)node;
            Object val = valueNode.getValue();
            String strVal = val == null ? "" : val.toString();
            Tag tag = Tag.STR;
            if (val instanceof Integer) {
                Tag tag2 = Tag.INT;
            } else if (val instanceof Double || val instanceof Float) {
                Tag tag3 = Tag.FLOAT;
            } else if (val instanceof Boolean) {
                Tag tag4 = Tag.BOOL;
            }
            result = new ScalarNode((Tag)var7_8, strVal, ScalarStyle.PLAIN);
        } else if (node instanceof IListNode) {
            IListNode listNode = (IListNode)node;
            ArrayList<Node> children = new ArrayList<Node>();
            Iterator<Object> iterator = listNode.getValue().iterator();
            while (iterator.hasNext()) {
                IConfigNode iConfigNode = (IConfigNode)iterator.next();
                children.add(YamlNodeConverter.convertGenericToNode(iConfigNode));
            }
            result = new SequenceNode(Tag.SEQ, children, FlowStyle.BLOCK);
        } else if (node instanceof IMapNode) {
            IMapNode mapNode = (IMapNode)node;
            ArrayList<NodeTuple> tuples = new ArrayList<NodeTuple>();
            for (Map.Entry entry : mapNode.entrySet()) {
                ScalarNode key = new ScalarNode(Tag.STR, (String)entry.getKey(), ScalarStyle.PLAIN);
                Node value = YamlNodeConverter.convertGenericToNode((IConfigNode)entry.getValue());
                tuples.add(new NodeTuple(key, value));
            }
            result = new MappingNode(Tag.MAP, tuples, FlowStyle.BLOCK);
        } else {
            throw new IllegalArgumentException("Unknown node type: " + String.valueOf(node.getClass()));
        }
        if (node.getComments() != null && !node.getComments().isEmpty()) {
            ArrayList<CommentLine> commentLines = new ArrayList<CommentLine>();
            for (String comment : node.getComments()) {
                commentLines.add(new CommentLine(Optional.empty(), Optional.empty(), comment, CommentType.BLOCK));
            }
            result.setBlockComments(commentLines);
        }
        return result;
    }
}

