/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.libs.jankson.impl;

import com.daqem.yamlconfig.libs.jankson.Jankson;
import com.daqem.yamlconfig.libs.jankson.JsonPrimitive;
import com.daqem.yamlconfig.libs.jankson.api.SyntaxError;
import com.daqem.yamlconfig.libs.jankson.impl.ParserContext;

public class TokenParserContext
implements ParserContext<JsonPrimitive> {
    private String token = "";
    private boolean complete = false;

    public TokenParserContext(int firstCodePoint) {
        this.token = this.token + (char)firstCodePoint;
    }

    @Override
    public boolean consume(int codePoint, Jankson loader) throws SyntaxError {
        if (this.complete) {
            return false;
        }
        if (codePoint == 126 || Character.isUnicodeIdentifierPart(codePoint)) {
            if (codePoint < 65535) {
                this.token = this.token + (char)codePoint;
                return true;
            }
            int temp = codePoint - 65536;
            int highSurrogate = (temp >>> 10) + 55296;
            int lowSurrogate = (temp & 0x3FF) + 56320;
            this.token = this.token + (char)highSurrogate;
            this.token = this.token + (char)lowSurrogate;
            return true;
        }
        this.complete = true;
        return false;
    }

    @Override
    public void eof() throws SyntaxError {
        this.complete = true;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public JsonPrimitive getResult() throws SyntaxError {
        return JsonPrimitive.of(this.token);
    }
}

