/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.networking.c2s;

import com.daqem.yamlconfig.YamlConfig;
import com.daqem.yamlconfig.YamlConfigExpectPlatform;
import com.daqem.yamlconfig.api.config.ConfigType;
import com.daqem.yamlconfig.api.config.IConfig;
import com.daqem.yamlconfig.event.ConfigEvent;
import com.daqem.yamlconfig.networking.YamlConfigNetworking;
import com.daqem.yamlconfig.networking.s2c.ClientboundSyncConfigPacket;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.permissions.Permission;
import net.minecraft.server.permissions.PermissionLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ServerboundSaveConfigPacket
implements CustomPacketPayload {
    private final IConfig config;
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundSaveConfigPacket> STREAM_CODEC = StreamCodec.of((buf, packet) -> {
        buf.writeEnum((Enum)packet.config.getType());
        packet.config.getType().getSerializer().toNetwork((RegistryFriendlyByteBuf)buf, packet.config);
    }, buf -> {
        ConfigType type = (ConfigType)buf.readEnum(ConfigType.class);
        IConfig config = type.getSerializer().fromNetwork((RegistryFriendlyByteBuf)buf);
        return new ServerboundSaveConfigPacket(config);
    });

    public ServerboundSaveConfigPacket(IConfig config) {
        this.config = config;
    }

    @NotNull
    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull CustomPacketPayload.Type<? extends @NotNull CustomPacketPayload> type() {
        return YamlConfigNetworking.SERVERBOUND_SAVE_CONFIG_PACKET;
    }

    public void handleServerSide(ServerPlayer serverPlayer) {
        if (serverPlayer.permissions().hasPermission((Permission)new Permission.HasCommandLevel(PermissionLevel.byId((int)2)))) {
            IConfig existingConfig = YamlConfig.CONFIG_MANAGER.getConfig(this.config.getModId(), this.config.getName());
            existingConfig.updateEntries(this.config.getEntries());
            existingConfig.save();
            ConfigEvent.fireUpdate(this.config, (Level)serverPlayer.level());
            if (existingConfig.getType() == ConfigType.COMMON) {
                Objects.requireNonNull(serverPlayer.level().getServer()).getPlayerList().getPlayers().forEach(player -> YamlConfigExpectPlatform.sendToPlayer(player, new ClientboundSyncConfigPacket(existingConfig)));
            }
        }
    }
}

