/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.valley.codec;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;

public class RefCodec<E>
extends MapCodec<Holder<E>> {
    private final ResourceKey<E> key;

    public RefCodec(ResourceKey<E> key) {
        this.key = key;
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.empty();
    }

    public <T> DataResult<Holder<E>> decode(DynamicOps<T> ops, MapLike<T> input) {
        if (ops instanceof RegistryOps) {
            RegistryOps regOps = (RegistryOps)ops;
            Optional registry = regOps.getter(this.key.registryKey());
            if (registry.isEmpty()) {
                return DataResult.error(() -> "Registry not found: " + String.valueOf(this.key.registryKey()));
            }
            Optional entry = ((HolderGetter)registry.get()).get(this.key);
            if (entry.isEmpty()) {
                return DataResult.error(() -> "Entry not found: " + String.valueOf(this.key));
            }
            return DataResult.success((Object)((Holder)entry.get()), (Lifecycle)Lifecycle.stable());
        }
        return DataResult.error(() -> "DynamicOps is not RegistryOps: " + ops.getClass().getName());
    }

    public <T> RecordBuilder<T> encode(Holder<E> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        return prefix;
    }

    public static <E> RefCodec<E> of(ResourceKey<E> key) {
        return new RefCodec<E>(key);
    }
}

