/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.valley.codec;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.terraforged.valley.math.Seed;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;

public class SeedCodec
extends MapCodec<Integer> {
    public static final int UNSEEDED = 0;
    private static final AtomicBoolean DISABLED = new AtomicBoolean(false);
    private final String key;

    private SeedCodec(String key) {
        this.key = key;
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.of(ops.createString(this.key));
    }

    public <T> DataResult<Integer> decode(DynamicOps<T> ops, MapLike<T> input) {
        if (DISABLED.get()) {
            return DataResult.success((Object)0);
        }
        Object value = input.get(this.key);
        if (value == null) {
            return DataResult.success((Object)Seed.NextInt());
        }
        int seed = ops.getNumberValue(value).map(Number::intValue).result().orElse(0);
        if (seed == 0) {
            return DataResult.success((Object)Seed.NextInt());
        }
        return DataResult.success((Object)seed);
    }

    public <T> RecordBuilder<T> encode(Integer input, DynamicOps<T> ops, RecordBuilder<T> builder) {
        if (DISABLED.get()) {
            return builder;
        }
        if (input != 0) {
            return builder.add(this.key, ops.createInt(input.intValue()));
        }
        return builder.add(this.key, ops.createInt(Seed.NextInt()));
    }

    public static SeedCodec FieldOf(String key) {
        return new SeedCodec(key);
    }

    public static void Disable(Runnable task) {
        DISABLED.set(true);
        task.run();
        DISABLED.set(false);
    }
}

