/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.valley.data;

import com.terraforged.valley.Valley;
import com.terraforged.valley.codec.SeedCodec;
import com.terraforged.valley.data.DataManager;
import com.terraforged.valley.data.DataUtils;
import com.terraforged.valley.world.density.NodeFunction;
import com.terraforged.valley.world.density.RiverFunction;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseRouterData;

public interface Datapack {
    public static final String PROFILE_DIR = "valley";
    public static final String PROFILE_ID = "file/valley";
    public static final DataManager MANAGER = new DataManager();

    public static void Bootstrap() {
        MANAGER.register(RiverFunction::Preset, NoiseRouterData.RIDGES, DensityFunction.DIRECT_CODEC, true);
        MANAGER.register(NodeFunction::Continents, NoiseRouterData.CONTINENTS, DensityFunction.DIRECT_CODEC, false);
    }

    public static void ExportDefault() {
        SeedCodec.Disable(() -> Datapack.ExportDefault(Valley.PresetsDir().resolve("default")));
    }

    public static void ExportDefault(Path dir) {
        Valley.LOG.info("Exporting datapack to: {}", (Object)dir);
        boolean result = true;
        result &= Datapack.ExportMeta(dir);
        for (DataManager.Entry<?> entry : MANAGER) {
            result &= entry.export(dir);
        }
        if (result) {
            Valley.LOG.info("Datapack export completed successfully");
        } else {
            Valley.LOG.error("Datapack export failed");
        }
    }

    public static boolean EnablePack(Path dir, PackRepository repo) {
        if (repo.getSelectedIds().contains(PROFILE_ID)) {
            return false;
        }
        if (Datapack.IsExistingSave(dir.getParent())) {
            return false;
        }
        Path pack = dir.resolve(PROFILE_DIR);
        if (!Files.exists(pack, new LinkOption[0])) {
            Datapack.ExportDefault(pack);
            repo.reload();
            if (!repo.getAvailableIds().contains(PROFILE_ID)) {
                Valley.LOG.error("Datapack export failed, cannot enable datapack: {}", (Object)PROFILE_ID);
                return false;
            }
        }
        Valley.LOG.info("Enabling datapack: {}", (Object)PROFILE_ID);
        return repo.addPack(PROFILE_ID);
    }

    private static boolean IsExistingSave(Path dir) {
        return Files.exists(dir.resolve("level.dat"), new LinkOption[0]);
    }

    private static boolean ExportMeta(Path dir) {
        Path file = dir.resolve("pack.mcmeta");
        MutableComponent description = Component.literal((String)"Valley Data Pack").withColor(65280);
        InclusiveRange versionRange = SharedConstants.getCurrentVersion().packVersion(PackType.SERVER_DATA).minorRange();
        DataManager.Metadata metadata = new DataManager.Metadata(new PackMetadataSection((Component)description, versionRange));
        return DataUtils.Export(file, metadata, DataManager.Metadata.CODEC, false);
    }
}

