/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.valley.sync;

import java.util.concurrent.atomic.AtomicInteger;

public class Computable {
    public static final int SHARED = 2;
    public static final int BLOCK = 4;
    public static final int SPIN = 8;
    public static final int DEFAULT_UNIQUE = 4;
    public static final int DEFAULT_SHARED = 6;
    public static final int COUNTDOWN_LATCH = 2;
    private static final int STATE_INITIAL = 0;
    private static final int STATE_COMPLETE = -1;
    final AtomicInteger state = new AtomicInteger(0);

    public final boolean compute() {
        return this.compute(4);
    }

    public final void complete() {
        this.complete(4);
    }

    public final boolean compute(int flags) {
        if ((flags & 2) == 2) {
            int currentState;
            do {
                if ((currentState = this.state.get()) != -1) continue;
                return false;
            } while (!this.state.compareAndSet(currentState, currentState + 1));
            return true;
        }
        int currentState = this.state.get();
        if (currentState == 0 && this.state.compareAndSet(0, 1)) {
            return true;
        }
        if (currentState == -1) {
            return false;
        }
        if ((flags & 4) == 4) {
            this.await(flags);
        }
        return false;
    }

    public final void complete(int flags) {
        if ((flags & 2) == 2) {
            int currentState;
            do {
                if ((currentState = this.state.get()) == 0 || currentState == -1) {
                    return;
                }
                if (currentState != 1 || !this.state.compareAndSet(currentState, -1)) continue;
                this.notify(flags);
                return;
            } while (currentState <= 1 || !this.state.compareAndSet(currentState, currentState - 1));
            if ((flags & 4) == 4) {
                this.await(flags);
            }
            return;
        }
        int oldState = this.state.getAndSet(-1);
        assert (oldState != 0);
        assert (oldState != -1);
        this.notify(flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notify(int flags) {
        if ((flags & 8) != 8) {
            Computable computable = this;
            synchronized (computable) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void await(int flags) {
        if ((flags & 8) == 8) {
            while (this.state.get() != -1) {
                Thread.onSpinWait();
            }
        } else {
            Computable computable = this;
            synchronized (computable) {
                while (this.state.get() != -1) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }
}

