/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.valley.world.density;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.terraforged.valley.codec.Codecs;
import com.terraforged.valley.codec.SeedCodec;
import com.terraforged.valley.math.Node;
import com.terraforged.valley.world.continent.Continent;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.jetbrains.annotations.NotNull;

public record NodeFunction(int seed, Continent.Config config) implements DensityFunction,
Node
{
    public static final MapCodec<NodeFunction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)SeedCodec.FieldOf("seed").forGetter(NodeFunction::seed), (App)Codecs.Noise.NOISE_TYPE.fieldOf("node").xmap(Continent.Config::new, Continent.Config::node).forGetter(NodeFunction::config)).apply((Applicative)i, NodeFunction::new));
    public static final KeyDispatchDataCodec<NodeFunction> HOLDER = KeyDispatchDataCodec.of(CODEC);

    @Override
    public double eval(int seed, double x, double y) {
        return this.config.node().eval(this.seed, x, y);
    }

    public double compute(DensityFunction.FunctionContext ctx) {
        return this.config.node().eval(this.seed, ctx.blockX(), ctx.blockZ());
    }

    public void fillArray(double[] density, DensityFunction.ContextProvider provider) {
        provider.fillAllDirectly(density, (DensityFunction)this);
    }

    @NotNull
    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return this;
    }

    public double minValue() {
        return this.config.node().min();
    }

    public double maxValue() {
        return this.config.node().max();
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return HOLDER;
    }

    public static NodeFunction Continents() {
        return new NodeFunction(0, Continent.CreateDefault());
    }
}

