/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.valley.world.density;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.terraforged.valley.codec.Codecs;
import com.terraforged.valley.codec.RefCodec;
import com.terraforged.valley.codec.SeedCodec;
import com.terraforged.valley.math.Node;
import com.terraforged.valley.math.Spline;
import com.terraforged.valley.world.density.DensityNode;
import com.terraforged.valley.world.river.River;
import com.terraforged.valley.world.river.RiverGenerator;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import org.jetbrains.annotations.NotNull;

public record RiverFunction(int seed, River.Config config, Spline output, DensityNode continents, River.RegionCache cache) implements DensityFunction.SimpleFunction
{
    public static final MapCodec<RiverFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SeedCodec.FieldOf("seed").forGetter(RiverFunction::seed), (App)Codecs.RIVER.fieldOf("config").orElseGet(River.Config::Defaults).forGetter(RiverFunction::config), (App)Codecs.SPLINE.fieldOf("shape").orElseGet(RiverFunction::DefaultOutput).forGetter(RiverFunction::output), (App)RefCodec.of(NoiseRouterData.CONTINENTS).xmap(DensityNode::new, DensityNode::entry).forGetter(RiverFunction::continents)).apply((Applicative)instance, RiverFunction::new));
    public static final KeyDispatchDataCodec<RiverFunction> CODEC_HOLDER = KeyDispatchDataCodec.of(CODEC);

    private RiverFunction(int seed, River.Config config, Spline output, DensityNode continents) {
        this(seed, config, output, continents, River.RegionCache.Create());
    }

    public double minValue() {
        return -1.0;
    }

    public double maxValue() {
        return 1.0;
    }

    public double compute(DensityFunction.FunctionContext ctx) {
        int x = ctx.blockX();
        int z = ctx.blockZ();
        Node noise = this.continents.node();
        double dist = RiverGenerator.Sample(this.seed, x, z, noise, this.config, this.cache);
        double sign = RiverGenerator.Sign(this.seed, x, z);
        return sign * this.output.eval(dist);
    }

    @NotNull
    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        this.continents.visit(visitor);
        return this;
    }

    @NotNull
    public KeyDispatchDataCodec<RiverFunction> codec() {
        return CODEC_HOLDER;
    }

    public static RiverFunction Preset() {
        return new RiverFunction(0, River.Config.Defaults(), RiverFunction.DefaultOutput(), DensityNode.EMPTY, null);
    }

    private static Spline DefaultOutput() {
        return Spline.Of(new double[][]{{0.0, 1.0}, {0.85, 0.3}, {1.0, 0.0}});
    }
}

