/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.valley.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.RecordBuilder;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public class TypeCodec<E>
implements Codec<E> {
    private static final String TYPE_KEY = "$type";
    private final Map<String, Holder<? extends E>> nameLookup = new HashMap<String, Holder<? extends E>>();
    private final Map<Class<?>, Holder<? extends E>> typeLookup = new IdentityHashMap();

    public <T extends E> void register(String name, Class<T> clazz, MapCodec<T> codec) {
        Holder<T> holder = new Holder<T>(name, clazz, codec);
        this.nameLookup.putIfAbsent(name, holder);
        this.typeLookup.put(clazz, holder);
    }

    public <T> DataResult<Pair<E, T>> decode(DynamicOps<T> ops, T input) {
        DataResult type = ops.get(input, TYPE_KEY).flatMap(arg_0 -> ops.getStringValue(arg_0));
        if (type.isError()) {
            return DataResult.error(() -> "Missing type key");
        }
        Holder<E> holder = this.nameLookup.get(type.getOrThrow());
        if (holder == null) {
            return DataResult.error(() -> "Unknown type: " + (String)type.getOrThrow());
        }
        return holder.decode(ops, input).map(TypeCodec::RemapResult);
    }

    public <T> DataResult<T> encode(E input, DynamicOps<T> ops, T prefix) {
        Holder<E> holder = this.typeLookup.get(input.getClass());
        if (holder == null) {
            return DataResult.error(() -> "Unregistered type: " + String.valueOf(input.getClass()));
        }
        return holder.encode(input, prefix, ops.mapBuilder().add(TYPE_KEY, ops.createString(holder.name())));
    }

    private static <E, T> Pair<E, T> RemapResult(Pair<? extends E, T> pair) {
        return Pair.of((Object)pair.getFirst(), (Object)pair.getSecond());
    }

    private record Holder<E>(String name, Class<E> type, MapCodec<E> codec) {
        public <T> DataResult<Pair<E, T>> decode(DynamicOps<T> ops, T input) {
            return this.codec.decoder().decode(ops, input);
        }

        public <V, T> DataResult<T> encode(V instance, T prefix, RecordBuilder<T> builder) {
            if (instance.getClass() == this.type) {
                E value = this.type.cast(instance);
                return this.codec.encode(value, builder.ops(), builder).build(prefix);
            }
            return DataResult.error(() -> "Invalid type: " + String.valueOf(instance.getClass()));
        }
    }
}

