/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.valley.math;

import com.terraforged.valley.math.Cell;
import com.terraforged.valley.math.Mth;
import com.terraforged.valley.math.Simplex;
import com.terraforged.valley.math.Spline;

public interface Node {
    public double eval(int var1, double var2, double var4);

    default public double min() {
        return -1.0;
    }

    default public double max() {
        return 1.0;
    }

    public static White White() {
        return White.INSTANCE;
    }

    public static Simplex Simplex() {
        return Simplex.INSTANCE;
    }

    public static Cell Cell(Cell.GridType grid, Cell.ResultType result, double jitter) {
        return new Cell(grid, result, jitter);
    }

    public static FBM Fbm(Node source, int octaves, double lacunarity, double gain) {
        double sumMin = 0.0;
        double sumMax = 0.0;
        double amplitude = 1.0;
        for (int i = 0; i < octaves; ++i) {
            sumMin += source.min() * amplitude;
            sumMax += source.max() * amplitude;
            amplitude *= gain;
        }
        return new FBM(source, octaves, lacunarity, gain, sumMin, sumMax);
    }

    public static Remap Remap(Node source, Spline spline) {
        return new Remap(source, spline);
    }

    public static Scale Scale(Node source, int scale) {
        return new Scale(source, scale, 1.0 / Mth.Max(scale, 1.0));
    }

    public static Warp Warp(Node source, Node warp, double frequency, double amplitude) {
        return new Warp(source, warp, frequency, amplitude);
    }

    public static interface White
    extends Node {
        public static final White INSTANCE = new White(){};

        @Override
        default public double eval(int seed, double x, double y) {
            return Mth.Noise(Mth.Hash(seed, Mth.Floor(x), Mth.Floor(y)));
        }
    }

    public record FBM(Node source, int octaves, double lacunarity, double gain, double min, double max) implements Modifier
    {
        @Override
        public double eval(int seed, double x, double y) {
            double amplitude = 1.0;
            double frequency = 1.0;
            double sum = 0.0;
            double max = 0.0;
            for (int i = 0; i < this.octaves; ++i) {
                sum += this.source.eval(seed, x * frequency, y * frequency) * amplitude;
                max += amplitude;
                amplitude *= this.gain;
                frequency *= this.lacunarity;
            }
            return sum / max;
        }
    }

    public record Remap(Node source, Spline spline) implements Modifier
    {
        @Override
        public double eval(int seed, double x, double y) {
            return this.spline.eval(this.source.eval(seed, x, y));
        }
    }

    public record Scale(Node source, int scale, double frequency) implements Modifier
    {
        public Scale(Node source, int scale) {
            this(source, scale, 1.0 / (double)scale);
        }

        @Override
        public double eval(int seed, double x, double y) {
            return this.source.eval(seed, x * this.frequency, y * this.frequency);
        }
    }

    public record Warp(Node source, Node warp, double frequency, double amplitude) implements Modifier
    {
        private static final int X_OFFSET = 1066037191;
        private static final int Y_OFFSET = 1720413743;

        @Override
        public double eval(int seed, double x, double y) {
            double sx = x * this.frequency;
            double sy = y * this.frequency;
            double wx = this.warp.eval(seed + 1066037191, sx, sy) * this.amplitude;
            double wy = this.warp.eval(seed + 1720413743, sx, sy) * this.amplitude;
            return this.source.eval(seed, x + wx, y + wy);
        }

        public double pointX(int seed, double x, double y) {
            return x + this.offsetX(seed, x, y);
        }

        public double pointY(int seed, double x, double y) {
            return y + this.offsetY(seed, x, y);
        }

        public double offsetX(int seed, double x, double y) {
            return this.warp.eval(seed + 1066037191, x * this.frequency, y * this.frequency) * this.amplitude;
        }

        public double offsetY(int seed, double x, double y) {
            return this.warp.eval(seed + 1720413743, x * this.frequency, y * this.frequency) * this.amplitude;
        }
    }

    public static interface Modifier
    extends Node {
        public Node source();

        @Override
        default public double min() {
            return this.source().min();
        }

        @Override
        default public double max() {
            return this.source().max();
        }
    }
}

