/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.valley.util;

import com.terraforged.valley.math.Mth;
import java.util.Arrays;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import java.util.function.IntFunction;

public interface Cache {
    public static final long NULL_KEY = Long.MIN_VALUE;

    private static int hash(long l) {
        return (int)Mth.Mix(l);
    }

    public static interface ComputeFunction<T> {
        public T apply(long var1);
    }

    public static class Concurrent<T> {
        protected static final int HASH_BITS = Integer.MAX_VALUE;
        protected final int mask;
        protected final Stamped<T>[] buckets;
        protected final IntFunction<T[]> constructor;

        public Concurrent(int capacity, int concurrency, IntFunction<T[]> constructor, Consumer<T> removalListener) {
            concurrency = 1 << Mth.SizeBits(concurrency);
            capacity = Mth.Floor((float)capacity / (float)concurrency);
            this.mask = concurrency - 1;
            this.buckets = Concurrent.CreateBuckets(concurrency);
            this.constructor = constructor;
            for (int i = 0; i < concurrency; ++i) {
                this.buckets[i] = new Stamped<T>(capacity, constructor, removalListener);
            }
        }

        public T computeIfAbsent(long key, ComputeFunction<T> function) {
            return this.buckets[this.index(key)].computeIfAbsent(key, function);
        }

        public void clear() {
            for (Stamped<T> bucket : this.buckets) {
                bucket.clear();
            }
        }

        protected int index(long key) {
            return Concurrent.spread(key) & this.mask;
        }

        protected static int spread(long h) {
            return (int)(h ^ h >>> 16) & Integer.MAX_VALUE;
        }

        protected static <T> Stamped<T>[] CreateBuckets(int size) {
            return new Stamped[size];
        }
    }

    public static class Stamped<T> {
        protected final long[] keys;
        protected final T[] values;
        protected final int mask;
        protected final Consumer<T> removalListener;
        protected final StampedLock lock = new StampedLock();

        public Stamped(int capacity, IntFunction<T[]> constructor, Consumer<T> removalListener) {
            capacity = 1 << Mth.SizeBits(capacity);
            this.mask = capacity - 1;
            this.keys = new long[capacity];
            this.values = constructor.apply(capacity);
            this.removalListener = removalListener;
            Arrays.fill(this.keys, Long.MIN_VALUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T computeIfAbsent(long key, ComputeFunction<T> function) {
            int index = Cache.hash(key) & this.mask;
            long readStamp = this.lock.tryOptimisticRead();
            long currentKey = this.keys[index];
            T currentValue = this.values[index];
            if (!this.lock.validate(readStamp)) {
                readStamp = this.lock.readLock();
                currentKey = this.keys[index];
                currentValue = this.values[index];
            }
            if (currentKey == key && currentValue != null) {
                if (StampedLock.isReadLockStamp(readStamp)) {
                    this.lock.unlockRead(readStamp);
                }
                return currentValue;
            }
            long writeStamp = this.lock.tryConvertToWriteLock(readStamp);
            try {
                if (writeStamp == 0L) {
                    if (StampedLock.isReadLockStamp(readStamp)) {
                        this.lock.unlock(readStamp);
                    }
                    writeStamp = this.lock.writeLock();
                    if (this.keys[index] == key && this.values[index] != null) {
                        T t = this.values[index];
                        return t;
                    }
                }
                T newValue = function.apply(key);
                this.keys[index] = key;
                this.values[index] = newValue;
                T t = newValue;
                return t;
            }
            finally {
                this.lock.unlockWrite(writeStamp);
                if (currentValue != null) {
                    this.removalListener.accept(currentValue);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            long stamp = this.lock.writeLock();
            try {
                for (int i = 0; i < this.keys.length; ++i) {
                    if (this.values[i] != null) {
                        this.removalListener.accept(this.values[i]);
                        this.values[i] = null;
                    }
                    this.keys[i] = Long.MIN_VALUE;
                }
            }
            finally {
                this.lock.unlockWrite(stamp);
            }
        }
    }

    public static class Linear<T> {
        protected final int size;
        protected final long[] keys;
        protected final T[] values;

        public Linear(IntFunction<T[]> constructor) {
            this(16, constructor);
        }

        public Linear(int size, IntFunction<T[]> constructor) {
            this.size = size;
            this.keys = new long[size];
            this.values = constructor.apply(size);
            Arrays.fill(this.keys, Long.MIN_VALUE);
        }

        public void clear() {
            Arrays.fill(this.keys, Long.MIN_VALUE);
            Arrays.fill(this.values, null);
        }

        public T computeIfAbsent(long key, ComputeFunction<T> function) {
            if (this.keys[0] == key) {
                return this.values[0];
            }
            if (this.keys[0] == Long.MIN_VALUE) {
                this.keys[0] = key;
                this.values[0] = function.apply(key);
                return this.values[0];
            }
            long lastKey = this.keys[0];
            T lastValue = this.values[0];
            for (int i = 1; i < this.size; ++i) {
                long tempKey = this.keys[i];
                this.keys[i] = lastKey;
                lastKey = tempKey;
                T tempValue = this.values[i];
                this.values[i] = lastValue;
                lastValue = tempValue;
                if (lastKey == key) {
                    this.keys[0] = lastKey;
                    this.values[0] = lastValue;
                    break;
                }
                if (lastKey == Long.MIN_VALUE) break;
            }
            if (this.keys[0] != key) {
                this.keys[0] = key;
                this.values[0] = function.apply(key);
            }
            return this.values[0];
        }
    }
}

