/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.valley.world.density;

import com.terraforged.valley.math.Mth;
import com.terraforged.valley.math.Node;
import net.minecraft.core.Holder;
import net.minecraft.world.level.levelgen.DensityFunction;

public class DensityNode {
    public static final DensityNode EMPTY = new DensityNode(null);
    private volatile DensityFunction density;
    private final Holder<DensityFunction> entry;

    public DensityNode(Holder<DensityFunction> entry) {
        this.entry = entry;
    }

    public Holder<DensityFunction> entry() {
        return this.entry;
    }

    public void visit(DensityFunction.Visitor visitor) {
        this.density = visitor.apply((DensityFunction)this.entry.value());
    }

    public Node node() {
        return Reader.Wrap(this.density);
    }

    private static class Reader
    implements Node,
    DensityFunction.FunctionContext {
        private static final ThreadLocal<Reader> LOCAL = ThreadLocal.withInitial(Reader::new);
        private int x;
        private int z;
        private DensityFunction density;

        private Reader() {
        }

        @Override
        public double eval(int seed, double x, double y) {
            this.x = Mth.Floor(x);
            this.z = Mth.Floor(y);
            return this.density.compute((DensityFunction.FunctionContext)this);
        }

        public int blockX() {
            return this.x;
        }

        public int blockY() {
            return 0;
        }

        public int blockZ() {
            return this.z;
        }

        static Node Wrap(DensityFunction density) {
            if (density instanceof Node) {
                Node node = (Node)density;
                return node;
            }
            Reader reader = LOCAL.get();
            reader.density = density;
            return reader;
        }
    }
}

