/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.valley.world.river;

import com.terraforged.valley.math.Cell;
import com.terraforged.valley.math.Mth;
import com.terraforged.valley.math.Node;
import com.terraforged.valley.math.Simplex;
import com.terraforged.valley.math.Spline;
import com.terraforged.valley.world.river.River;

public interface RiverGenerator {
    public static final double RIVER_OUTER = 0.9;
    public static final double RIVER_INNER = 1.0;
    public static final double VALLEY_OUTER = 0.0;
    public static final double VALLEY_INNER = 0.9;
    public static final double POINT_JITTER = 0.5;
    public static final double WARP_STRENGTH = 0.5;
    public static final int SEGMENT_COUNT = 2;
    public static final double SEGMENT_GAIN = 0.5;
    public static final double SEGMENT_JITTER = 0.5;
    public static final int SIGN_SEED = 716498721;
    public static final double SIGN_FREQ = 4.8828125E-4;
    public static final Node.Warp WARP = RiverGenerator.RiverWarp();

    public static double Sign(int seed, int x, int z) {
        return Simplex.FBM(seed + 716498721, (double)x * 4.8828125E-4, (double)z * 4.8828125E-4, 2, 2.0, 0.5) >= 0.0 ? 1.0 : -1.0;
    }

    public static double Sample(int seed, int x, int y, Node noise, River.Config config, River.RegionCache cache) {
        River.Sampler sampler = River.Sampler.LOCAL.get();
        if (x == sampler.cachedX && y == sampler.cachedZ) {
            return sampler.cachedValue;
        }
        if (noise.eval(seed, x, y) < config.coast()) {
            sampler.cachedX = x;
            sampler.cachedZ = y;
            sampler.cachedValue = 0.0;
            return 0.0;
        }
        double result = 0.0;
        double freq = config.freq();
        Spline riverSpline = config.riverRadius();
        Spline valleySpline = config.valleyRadius();
        River.Region region = RiverGenerator.GenRegion(seed, (double)x * freq, (double)y * freq, noise, config, sampler, cache);
        double px = WARP.pointX(seed, x, y) * freq;
        double py = WARP.pointY(seed, x, y) * freq;
        for (int i = 0; i < region.size; ++i) {
            double falloff;
            double riverRadius;
            double t = region.segments[i].project(px, py);
            double dist2 = region.segments[i].dist2(px, py, t);
            if (dist2 < (riverRadius = riverSpline.eval(falloff = region.segments[i].noise(t))) * riverRadius) {
                double blend = Mth.Sqrt(dist2) / riverRadius;
                result = Math.max(result, Mth.Lerp(1.0, 0.9, blend));
                continue;
            }
            double valleyRadius = valleySpline.eval(falloff);
            if (!(dist2 < valleyRadius * valleyRadius)) continue;
            double blend = (Mth.Sqrt(dist2) - riverRadius) / (valleyRadius - riverRadius);
            result = Math.max(result, Mth.Lerp(0.9, 0.0, blend));
        }
        sampler.cachedX = x;
        sampler.cachedZ = y;
        sampler.cachedValue = result;
        return result;
    }

    public static River.Region GenRegion(int seed, double x, double y, Node noise, River.Config config, River.Sampler sampler, River.RegionCache cache) {
        int fy;
        int fx = Mth.Floor(x);
        River.Region region = sampler.region(fx, fy = Mth.Floor(y), cache);
        if (region.compute()) {
            int i;
            double scale = config.scale();
            River.Region.Buffer buffer = sampler.buffer;
            for (i = 0; i < 81; ++i) {
                int cx = fx + River.SAMPLE_OFFSETS[i][0];
                int cy = fy + River.SAMPLE_OFFSETS[i][1];
                int hash = Mth.Hash(seed, cx, cy);
                sampler.x[i] = Cell.PointX2D(hash, cx, cy, 0.5);
                sampler.y[i] = Cell.PointY2D(hash, cx, cy, 0.5);
                sampler.hash[i] = hash;
            }
            for (i = 0; i < 81; ++i) {
                double px = sampler.x[i] * scale;
                double py = sampler.y[i] * scale;
                sampler.noise[i] = noise.eval(seed, px, py);
            }
            int[] nArray = River.EVAL_CELLS;
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                int c;
                int outgoing = c = nArray[j];
                int incoming = 0;
                for (int j2 = 0; j2 < River.CONNECTION_CELLS.length; ++j2) {
                    int offset0 = River.CONNECTION_CELLS[j2];
                    int n0 = c + offset0;
                    if (sampler.noise[n0] < sampler.noise[outgoing]) {
                        outgoing = n0;
                        continue;
                    }
                    int outgoing0 = n0;
                    for (int offset1 : River.CONNECTION_CELLS) {
                        int n1 = n0 + offset1;
                        if (!(sampler.noise[n1] < sampler.noise[outgoing0])) continue;
                        outgoing0 = n1;
                    }
                    if (outgoing0 != c) continue;
                    incoming = Mth.Set(incoming, j2);
                }
                if (outgoing == c) {
                    for (int i2 = 0; i2 < River.CONNECTION_CELLS.length; ++i2) {
                        if (Mth.IsSet(incoming, i2)) continue;
                        int index = c + River.CONNECTION_CELLS[i2];
                        if (outgoing != c && !(sampler.noise[index] < sampler.noise[outgoing])) continue;
                        outgoing = index;
                    }
                    if (outgoing == c) continue;
                }
                int hash = sampler.hash[c];
                double ax = sampler.x[c];
                double ay = sampler.y[c];
                double an = sampler.noise[c];
                double bx = sampler.x[outgoing];
                double by = sampler.y[outgoing];
                double bn = sampler.noise[outgoing];
                double segmentAlpha = Mth.Normalize(bn, config.coast(), 0.5);
                int segments = 1 + Mth.Floor(2.0 * segmentAlpha);
                RiverGenerator.CollectSegments(ax, ay, an, bx, by, bn, hash, segments, 0.5, 0.5, buffer);
            }
            region.transfer(buffer);
            region.complete();
        }
        return region;
    }

    public static void CollectSegments(double ax, double ay, double an, double bx, double by, double bn, int seed, int depth, double scale, double gain, River.Region.Buffer buffer) {
        if (depth > 0) {
            double dx = bx - ax;
            double dy = by - ay;
            double dir = (seed & 1) == 0 ? 0.5 : -0.5;
            double mx = ax + dx * 0.5 + dy * dir * scale;
            double my = ay + dy * 0.5 + dx * dir * scale;
            double mn = (an + bn) * 0.5;
            RiverGenerator.CollectSegments(ax, ay, an, mx, my, mn, Mth.Mix(seed - 1), depth - 1, scale * gain, gain, buffer);
            RiverGenerator.CollectSegments(mx, my, mn, bx, by, bn, Mth.Mix(seed + 1), depth - 1, scale * gain, gain, buffer);
        } else {
            double dir = (Mth.Mix(seed + 1066037191) & 1) == 0 ? 0.5 : -0.5;
            double warp = dir * gain;
            buffer.add(River.Segment.Of(ax, ay, an, bx, by, bn, warp));
        }
    }

    private static Node.Warp RiverWarp() {
        return Node.Warp(Simplex.INSTANCE, Node.Fbm(Simplex.INSTANCE, 2, 2.5, 0.5), 0.05, 3.0);
    }
}

