/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.valley.codec;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.terraforged.valley.codec.TypeCodec;
import com.terraforged.valley.math.Cell;
import com.terraforged.valley.math.Node;
import com.terraforged.valley.math.Simplex;
import com.terraforged.valley.math.Spline;
import com.terraforged.valley.world.river.River;

public interface Codecs {
    public static final MapCodec<Spline> SPLINE = RecordCodecBuilder.mapCodec(i -> i.group((App)Misc.SPLINE_POINT.listOf().fieldOf("points").forGetter(Spline::toList)).apply((Applicative)i, Spline::FromList));
    public static final Codec<River.Config> RIVER = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("scale").orElseGet(River.DEFAULTS::scale).forGetter(River.Config::scale), (App)Codec.doubleRange((double)-1.0, (double)1.0).fieldOf("ocean").orElseGet(River.DEFAULTS::ocean).forGetter(River.Config::ocean), (App)Codec.doubleRange((double)-1.0, (double)1.0).fieldOf("coast").orElseGet(River.DEFAULTS::coast).forGetter(River.Config::coast), (App)SPLINE.fieldOf("river_radius").orElseGet(River.DEFAULTS::riverRadius).forGetter(River.Config::riverRadius), (App)SPLINE.fieldOf("valley_radius").orElseGet(River.DEFAULTS::valleyRadius).forGetter(River.Config::valleyRadius)).apply((Applicative)instance, River.Config::new));

    public static void Bootstrap() {
        Noise.NOISE_TYPE.register("Simplex", Simplex.class, Noise.SIMPLEX);
        Noise.NOISE_TYPE.register("Cell", Cell.class, Noise.CELL);
        Noise.NOISE_TYPE.register("FBM", Node.FBM.class, Noise.FBM);
        Noise.NOISE_TYPE.register("Remap", Node.Remap.class, Noise.REMAP);
        Noise.NOISE_TYPE.register("Scale", Node.Scale.class, Noise.SCALE);
        Noise.NOISE_TYPE.register("Warp", Node.Warp.class, Noise.WARP);
    }

    public static interface Noise {
        public static final TypeCodec<Node> NOISE_TYPE = new TypeCodec();
        public static final MapCodec<Simplex> SIMPLEX = MapCodec.unit((Object)Simplex.INSTANCE);
        public static final Codec<Cell.GridType> GRID_TYPE = Codec.stringResolver(Enum::name, Cell.GridType::valueOf);
        public static final Codec<Cell.ResultType> RESULT_TYPE = Codec.stringResolver(Enum::name, Cell.ResultType::valueOf);
        public static final MapCodec<Cell> CELL = RecordCodecBuilder.mapCodec(i -> i.group((App)GRID_TYPE.fieldOf("grid").forGetter(Cell::grid), (App)RESULT_TYPE.fieldOf("result").forGetter(Cell::result), (App)Codec.doubleRange((double)0.0, (double)1.0).fieldOf("jitter").forGetter(Cell::jitter)).apply((Applicative)i, Cell::new));
        public static final MapCodec<Node.FBM> FBM = RecordCodecBuilder.mapCodec(i -> i.group((App)NOISE_TYPE.fieldOf("source").forGetter(Node.FBM::source), (App)Codec.INT.fieldOf("octaves").forGetter(Node.FBM::octaves), (App)Codec.DOUBLE.fieldOf("lacunarity").forGetter(Node.FBM::lacunarity), (App)Codec.DOUBLE.fieldOf("gain").forGetter(Node.FBM::gain)).apply((Applicative)i, Node::Fbm));
        public static final MapCodec<Node.Remap> REMAP = RecordCodecBuilder.mapCodec(i -> i.group((App)NOISE_TYPE.fieldOf("source").forGetter(Node.Remap::source), (App)SPLINE.fieldOf("spline").forGetter(Node.Remap::spline)).apply((Applicative)i, Node::Remap));
        public static final MapCodec<Node.Scale> SCALE = RecordCodecBuilder.mapCodec(i -> i.group((App)NOISE_TYPE.fieldOf("source").forGetter(Node.Scale::source), (App)Codec.INT.fieldOf("scale").forGetter(Node.Scale::scale)).apply((Applicative)i, Node::Scale));
        public static final MapCodec<Node.Warp> WARP = RecordCodecBuilder.mapCodec(i -> i.group((App)NOISE_TYPE.fieldOf("source").forGetter(Node.Warp::source), (App)NOISE_TYPE.fieldOf("warp").forGetter(Node.Warp::warp), (App)Codec.DOUBLE.fieldOf("frequency").forGetter(Node.Warp::frequency), (App)Codec.DOUBLE.fieldOf("amplitude").forGetter(Node.Warp::amplitude)).apply((Applicative)i, Node::Warp));
    }

    public static interface Misc {
        public static final Codec<Spline.Point> SPLINE_POINT = Codec.DOUBLE.listOf(2, 2).xmap(Spline.Point::FromList, Spline.Point::toList);
    }
}

