/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.valley.data;

import com.google.gson.FormattingStyle;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.terraforged.valley.Valley;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.minecraft.class_5321;

public interface DataUtils {
    public static <T> boolean Export(Path dir, T value, class_5321<?> key, Codec<T> codec) {
        return DataUtils.Export(DataUtils.EntryPath(dir, key), value, codec, true);
    }

    public static <T> boolean Export(Path file, T value, Codec<T> codec, boolean sort) {
        Valley.LOG.info("- Exporting file to: {}", (Object)file.toAbsolutePath());
        return codec.encode(value, (DynamicOps)JsonOps.INSTANCE, null).ifError(e -> Valley.LOG.error("{}", (Object)e.message())).ifSuccess(json -> {
            try {
                Path path = file.toAbsolutePath();
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter out = Files.newBufferedWriter(path, new OpenOption[0]);){
                    JsonWriter writer = new JsonWriter((Writer)out);
                    writer.setFormattingStyle(FormattingStyle.PRETTY);
                    Streams.write((JsonElement)(sort ? DataUtils.Sort(json) : json), (JsonWriter)writer);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).isSuccess();
    }

    public static Path EntryPath(Path dir, class_5321<?> key) {
        return dir.resolve("data").resolve(key.method_41185().method_12836()).resolve(key.method_41185().method_12832()).resolve(key.method_29177().method_12832() + ".json");
    }

    private static JsonElement Sort(JsonElement element) {
        if (!element.isJsonObject()) {
            return element;
        }
        JsonObject result = new JsonObject();
        element.getAsJsonObject().entrySet().stream().sorted(DataUtils::Sort).forEach(entry -> result.add((String)entry.getKey(), DataUtils.Sort((JsonElement)entry.getValue())));
        return result;
    }

    private static int Sort(Map.Entry<String, JsonElement> a, Map.Entry<String, JsonElement> b) {
        int orderB;
        int orderA = DataUtils.Order(a.getValue());
        if (orderA == (orderB = DataUtils.Order(b.getValue()))) {
            return a.getKey().compareTo(b.getKey());
        }
        return orderA - orderB;
    }

    private static int Order(JsonElement element) {
        if (element.isJsonPrimitive()) {
            return 0;
        }
        if (element.isJsonArray()) {
            return 1;
        }
        return 2;
    }
}

