/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.valley.data;

import com.terraforged.valley.Valley;
import com.terraforged.valley.codec.SeedCodec;
import com.terraforged.valley.data.DataManager;
import com.terraforged.valley.data.DataUtils;
import com.terraforged.valley.world.density.NodeFunction;
import com.terraforged.valley.world.density.RiverFunction;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_3264;
import net.minecraft.class_3272;
import net.minecraft.class_3283;
import net.minecraft.class_5250;
import net.minecraft.class_6497;
import net.minecraft.class_6910;
import net.minecraft.class_6954;

public interface Datapack {
    public static final String PROFILE_DIR = "valley";
    public static final String PROFILE_ID = "file/valley";
    public static final DataManager MANAGER = new DataManager();

    public static void Bootstrap() {
        MANAGER.register(RiverFunction::Preset, class_6954.field_37124, class_6910.field_37057, true);
        MANAGER.register(NodeFunction::Continents, class_6954.field_37122, class_6910.field_37057, false);
    }

    public static void ExportDefault() {
        SeedCodec.Disable(() -> Datapack.ExportDefault(Valley.PresetsDir().resolve("default")));
    }

    public static void ExportDefault(Path dir) {
        Valley.LOG.info("Exporting datapack to: {}", (Object)dir);
        boolean result = true;
        result &= Datapack.ExportMeta(dir);
        for (DataManager.Entry<?> entry : MANAGER) {
            result &= entry.export(dir);
        }
        if (result) {
            Valley.LOG.info("Datapack export completed successfully");
        } else {
            Valley.LOG.error("Datapack export failed");
        }
    }

    public static boolean EnablePack(Path dir, class_3283 repo) {
        if (repo.method_29210().contains(PROFILE_ID)) {
            return false;
        }
        if (Datapack.IsExistingSave(dir.getParent())) {
            return false;
        }
        Path pack = dir.resolve(PROFILE_DIR);
        if (!Files.exists(pack, new LinkOption[0])) {
            Datapack.ExportDefault(pack);
            repo.method_14445();
            if (!repo.method_29206().contains(PROFILE_ID)) {
                Valley.LOG.error("Datapack export failed, cannot enable datapack: {}", (Object)PROFILE_ID);
                return false;
            }
        }
        Valley.LOG.info("Enabling datapack: {}", (Object)PROFILE_ID);
        return repo.method_49427(PROFILE_ID);
    }

    private static boolean IsExistingSave(Path dir) {
        return Files.exists(dir.resolve("level.dat"), new LinkOption[0]);
    }

    private static boolean ExportMeta(Path dir) {
        Path file = dir.resolve("pack.mcmeta");
        class_5250 description = class_2561.method_43470((String)"Valley Data Pack").method_54663(65280);
        class_6497 versionRange = class_155.method_16673().method_70592(class_3264.field_14190).method_72318();
        DataManager.Metadata metadata = new DataManager.Metadata(new class_3272((class_2561)description, versionRange));
        return DataUtils.Export(file, metadata, DataManager.Metadata.CODEC, false);
    }
}

